/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class ClassLoaderResourceLocator
extends CommonLocator {
    private final ClassLoader classLoader;
    private final String name;
    private String encoding;
    private ILocator tempFileLocator;

    public ClassLoaderResourceLocator(ClassLoader classLoader, String name) {
        this.classLoader = classLoader;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClassLoaderResourceLocator)) {
            return false;
        }
        return this.name.equals(((ClassLoaderResourceLocator)obj).name) && this.classLoader.equals(((ClassLoaderResourceLocator)obj).classLoader);
    }

    @Override
    public boolean exists() {
        return this.getClassLoader().getResource(this.getName()) != null;
    }

    @Override
    public ILocator getChild(String childName) {
        String child = String.valueOf(this.getName()) + "/" + childName;
        ClassLoaderResourceLocator result = new ClassLoaderResourceLocator(this.getClassLoader(), child);
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getClassLoader().getResourceAsStream(this.getName());
    }

    @Override
    public String getLocalName() {
        if (this.getName() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public ILocator getParent() {
        int index = this.getName().lastIndexOf("/");
        if (index > -1) {
            String parentname = this.getName().substring(0, index);
            return new ClassLoaderResourceLocator(this.getClassLoader(), parentname);
        }
        return null;
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String newEncoding) throws IOException {
        if (newEncoding == null || newEncoding.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    @Override
    public String getType() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(new File(this.getName()));
    }

    @Override
    public String getTypedName() {
        if (this.getName() == null) {
            return "<unknown>";
        }
        return new File(this.getName()).getName();
    }

    @Override
    public Writer getWriter() throws IOException {
        this.throwReadOnly();
        return null;
    }

    @Override
    public Writer getWriter(String pEncoding) throws IOException {
        this.throwReadOnly();
        return null;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public URL toURL() {
        return null;
    }
}

