/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public abstract class CommonLocator
implements ILocator,
Serializable {
    static final long serialVersionUID = 1L;
    private boolean readOnly = false;

    protected ILocator createTempFileLocator() throws IOException {
        File file = TempTools.createTempFile("locator", ".tmp");
        file.deleteOnExit();
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = this.getInputStream();
            os = new FileOutputStream(file);
            StreamTools.copyStream(is, false, os, false);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
        FileLocator tempFileLocator = new FileLocator(file);
        tempFileLocator.setReadOnly();
        return tempFileLocator;
    }

    @Override
    public void delete() throws IOException {
        this.throwUnsupported();
    }

    @Override
    public long getLength() throws IOException {
        return -1L;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void rename(String newName) throws IOException {
        this.throwUnsupported();
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    protected void throwReadOnly() throws IOException {
        throw new IOException("read only");
    }

    protected void throwUnsupported() throws IOException {
        throw new IOException("unsupported operation");
    }
}

