/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.stream.TempFileOutputStream;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;

public class FileLocator
extends CommonLocator
implements ILockSupport,
ICharsetAccess {
    private File file;
    private String charset;
    private boolean outOfSynch;
    private boolean synchSynchronous = false;
    private long lastModified = 0L;
    private boolean useTempFile = false;
    private File canonicalFile;
    private final boolean append;

    public FileLocator(File file) {
        this.file = file;
        this.append = false;
    }

    public FileLocator(File file, boolean append) {
        this.file = file;
        this.append = append;
    }

    public FileLocator(String path) {
        this(new File(path));
    }

    @Override
    public void delete() throws IOException {
        if (this.getFile() == null) {
            return;
        }
        this.getFile().delete();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileLocator)) {
            return false;
        }
        return this.getCanonicalFile().equals(((FileLocator)obj).getCanonicalFile());
    }

    @Override
    public boolean exists() {
        return this.getFile().exists();
    }

    public File getCanonicalFile() {
        if (this.canonicalFile == null) {
            try {
                this.canonicalFile = this.getFile().getCanonicalFile();
            }
            catch (IOException e) {
                this.canonicalFile = this.getFile();
            }
        }
        return this.canonicalFile;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String name) {
        File childfile = new File(this.getFile(), name);
        FileLocator result = new FileLocator(childfile);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String getFullName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getAbsolutePath();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.getLastModified();
        return new FileInputStream(this.getFile());
    }

    protected long getLastModified() {
        if (this.lastModified == 0L && this.file.exists()) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    @Override
    public long getLength() throws IOException {
        return this.file.length();
    }

    @Override
    public String getLocalName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return FileTools.getBaseName(this.getFile());
    }

    @Override
    public ILock getLock() {
        return new FileLocatorLock();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.getLastModified();
        File parentFile = FileTools.getParentFile(this.getFile());
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (this.isUseTempFile()) {
            return new TempFileOutputStream(this.getFile(), "tmp_", "." + this.getType());
        }
        return new FileOutputStream(this.getFile(), this.isAppend());
    }

    @Override
    public ILocator getParent() {
        File parentFile = FileTools.getParentFile(this.getFile());
        if (parentFile == null) {
            return null;
        }
        FileLocator result = new FileLocator(parentFile);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        this.getLastModified();
        if (this.isUseTempFile()) {
            throw new UnsupportedOperationException("no random access to temp file");
        }
        return new de.intarsys.tools.randomaccess.RandomAccessFile(this.getFile());
    }

    @Override
    public Reader getReader() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getCharset());
    }

    @Override
    public Reader getReader(String charset) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(charset)) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), charset);
    }

    @Override
    public String getType() {
        if (this.getFile() == null) {
            return "<unknown>";
        }
        return FileTools.getExtension(this.getFile());
    }

    @Override
    public String getTypedName() {
        if (this.getFile() == null) {
            return "unknown";
        }
        return this.getFile().getName();
    }

    @Override
    public Writer getWriter() throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(this.getCharset())) {
            return new OutputStreamWriter(this.getOutputStream());
        }
        return new OutputStreamWriter(this.getOutputStream(), this.getCharset());
    }

    @Override
    public Writer getWriter(String charset) throws IOException {
        this.getLastModified();
        if (StringTools.isEmpty(charset)) {
            return this.getWriter();
        }
        return new OutputStreamWriter(this.getOutputStream(), charset);
    }

    public int hashCode() {
        try {
            return this.getFile().getCanonicalFile().hashCode();
        }
        catch (IOException e) {
            return 17;
        }
    }

    public boolean isAppend() {
        return this.append;
    }

    @Override
    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    @Override
    public synchronized boolean isOutOfSynch() {
        if (this.isSynchSynchronous()) {
            this.synch();
        }
        return this.outOfSynch;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReadOnly() {
        IRandomAccess r;
        block7: {
            block8: {
                if (super.isReadOnly()) {
                    return true;
                }
                r = null;
                try {
                    if (!this.getFile().exists()) {
                        if (!this.getFile().createNewFile()) break block7;
                        this.getFile().delete();
                        break block8;
                    }
                    r = this.getRandomAccess();
                    if (r == null || r.isReadOnly()) break block7;
                }
                catch (IOException e) {
                    StreamTools.close(r);
                    return true;
                }
                catch (Throwable throwable) {
                    StreamTools.close(r);
                    throw throwable;
                }
            }
            StreamTools.close(r);
            return false;
        }
        StreamTools.close(r);
        return true;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public boolean isUseTempFile() {
        return this.useTempFile;
    }

    @Override
    public ILocator[] listLocators(final ILocatorNameFilter filter) throws IOException {
        if (!this.getFile().exists()) {
            throw new FileNotFoundException(String.valueOf(this.getFile().getName()) + " not found");
        }
        if (!this.getFile().isDirectory()) {
            throw new IOException(String.valueOf(this.getFile().getName()) + " not a directory");
        }
        File[] candidates = filter == null ? this.getFile().listFiles() : this.getFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String current) {
                return filter.accept(FileLocator.this, current);
            }
        });
        if (candidates == null) {
            throw new IOException("error listing resources");
        }
        ILocator[] result = new ILocator[candidates.length];
        int i = 0;
        while (i < result.length) {
            FileLocator l = new FileLocator(candidates[i].getPath());
            l.setSynchSynchronous(this.isSynchSynchronous());
            l.setCharset(this.getCharset());
            result[i] = l;
            ++i;
        }
        return result;
    }

    @Override
    public void rename(String newName) throws IOException {
        if (this.getFile() == null) {
            return;
        }
        File newFile = new File(newName);
        if (!newFile.isAbsolute()) {
            File parent = FileTools.getParentFile(this.getFile());
            newFile = parent == null ? new File(newName) : new File(parent, newName);
        }
        FileTools.renameFile(this.getFile(), newFile);
        this.file = newFile;
        this.canonicalFile = null;
        this.lastModified = 0L;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSynchSynchronous(boolean synchSynchronous) {
        this.synchSynchronous = synchSynchronous;
    }

    public void setUseTempFile(boolean useTempFile) {
        this.useTempFile = useTempFile;
    }

    @Override
    public synchronized void synch() {
        if (this.getFile() == null) {
            return;
        }
        if (this.getLastModified() != this.getFile().lastModified()) {
            LogTools.getLogger(this.getClass()).log(Level.FINEST, "'" + this.getFullName() + "' out of synch!");
            this.outOfSynch = true;
        }
    }

    public String toString() {
        return this.getFile().toString();
    }

    @Override
    public URL toURL() {
        try {
            return this.getFile().toURI().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    class FileLocatorLock
    implements ILock {
        private RandomAccessFile ra;

        FileLocatorLock() {
        }

        @Override
        public boolean acquire(Object owner, ILockLevel level) {
            try {
                this.ra = new RandomAccessFile(FileLocator.this.getFile(), "r");
                return true;
            }
            catch (FileNotFoundException e) {
                return false;
            }
        }

        @Override
        public void release(Object owner) {
            StreamTools.close(this.ra);
        }
    }
}

