/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectValueHolder;
import java.io.File;
import java.io.IOException;

public class FileLocatorFactory
extends CommonLocatorFactory {
    private boolean synchSynchronous = true;
    private final IValueHolder<File> parent;

    public FileLocatorFactory() {
        this.parent = new ObjectValueHolder<File>(FileEnvironment.get().getBaseDir());
    }

    public FileLocatorFactory(File file) {
        this.parent = new ObjectValueHolder<File>(file);
    }

    public FileLocatorFactory(IValueHolder<File> vh) {
        this.parent = vh;
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        location = FileTools.trimPath(location);
        File absolutePath = FileTools.resolvePath(this.parent.get(), location);
        FileLocator result = new FileLocator(absolutePath);
        result.setSynchSynchronous(this.isSynchSynchronous());
        return result;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public void setSynchSynchronous(boolean synchSynchronous) {
        this.synchSynchronous = synchSynchronous;
    }
}

