/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.charset.ICharsetSupport;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ClassLoaderResourceLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LookupLocatorFactory;
import de.intarsys.tools.locator.RenamedLocator;
import de.intarsys.tools.locator.SchemeBasedLocatorFactory;
import de.intarsys.tools.locator.StringLocator;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.reader.TaggedReader;
import de.intarsys.tools.reflect.IClassLoaderSupport;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class LocatorTools {
    public static final String PATH_SEPARATOR = ";";

    public static void checkHash(ILocator locator, Object hash) throws IOException {
        IDigest digest = DigestTools.createDigest(hash);
        if (digest == null) {
            return;
        }
        IDigest docDigest = LocatorTools.digest(locator, digest.getAlgorithmName());
        if (!docDigest.equals(digest)) {
            throw new IOException("document digest validation failed (" + locator.getFullName() + ")");
        }
    }

    @Deprecated
    public static void checkHash(ILocator locator, String algorithmName, Object hash) throws IOException {
        LocatorTools.checkHash(locator, hash);
    }

    public static void copy(ILocator source, ILocator target) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            is = source.getInputStream();
            os = target.getOutputStream();
            StreamTools.copyStream(is, false, os, false);
        }
        finally {
            StreamTools.close(is);
            StreamTools.close(os);
        }
    }

    public static ILocatorFactory createLocalLocatorFactory(final Object context, ILocatorFactory fallback) {
        SchemeBasedLocatorFactory sblf = new SchemeBasedLocatorFactory();
        if (context instanceof IFileEnvironment) {
            FileLocatorFactory flf = new FileLocatorFactory(new IValueHolder<File>(){

                @Override
                public File get() {
                    return ((IFileEnvironment)context).getBaseDir();
                }

                @Override
                public File set(File newValue) {
                    throw new UnsupportedOperationException();
                }
            });
            sblf.registerLocatorFactory("file", flf);
            sblf.setNoSchemeLocatorFactory(flf);
        }
        if (context instanceof IClassLoaderSupport) {
            ClassLoaderResourceLocatorFactory clrlf = new ClassLoaderResourceLocatorFactory(new IValueHolder<ClassLoader>(){

                @Override
                public ClassLoader get() {
                    return ((IClassLoaderSupport)context).getClassLoader();
                }

                @Override
                public ClassLoader set(ClassLoader newValue) {
                    throw new UnsupportedOperationException();
                }
            });
            sblf.registerLocatorFactory("classpath", clrlf);
        }
        if (fallback == null) {
            return sblf;
        }
        LookupLocatorFactory llf = new LookupLocatorFactory();
        llf.addLocatorFactory(sblf);
        llf.addLocatorFactory(fallback);
        return llf;
    }

    public static ILocator createLocator(Object value, ILocatorFactory factory, ILocator defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof ILocator) {
            return (ILocator)value;
        }
        if (value instanceof ILocatorSupport) {
            return ((ILocatorSupport)value).getLocator();
        }
        if (value instanceof IArgs) {
            ILocator resultLocator = null;
            IArgs tempArgs = (IArgs)value;
            String charset = ArgTools.getString(tempArgs, "charset", null);
            Object tempLocator = tempArgs.get("locator");
            if (tempLocator == null) {
                tempLocator = tempArgs.get("path");
            }
            if (tempLocator != null && (resultLocator = LocatorTools.createLocator(tempLocator, factory, null)) instanceof ICharsetAccess && charset != null) {
                ((ICharsetAccess)((Object)resultLocator)).setCharset(charset);
            }
            if (resultLocator == null) {
                String name = ArgTools.getString(tempArgs, "name", "locator.bytes");
                name = FileTools.getFileName(name);
                Object tempContent = tempArgs.get("content");
                if (tempContent instanceof ILocator) {
                    resultLocator = (ILocator)tempContent;
                } else if (tempContent instanceof byte[]) {
                    resultLocator = new ByteArrayLocator((byte[])tempContent, name);
                } else if (tempContent instanceof String) {
                    byte[] bytes = Base64.decode((String)tempContent);
                    resultLocator = new ByteArrayLocator(bytes, name);
                } else {
                    try {
                        byte[] bytes = ConverterRegistry.get().convert(tempContent, byte[].class);
                        resultLocator = new ByteArrayLocator(bytes, name);
                    }
                    catch (ConversionException e1) {
                        try {
                            String string = ConverterRegistry.get().convert(tempContent, String.class);
                            byte[] bytes = Base64.decode(string);
                            resultLocator = new ByteArrayLocator(bytes, name);
                        }
                        catch (ConversionException conversionException) {
                            // empty catch block
                        }
                    }
                    if (resultLocator == null) {
                        resultLocator = new ByteArrayLocator(null, name);
                    }
                }
                if (resultLocator instanceof ICharsetAccess && charset != null) {
                    ((ICharsetAccess)((Object)resultLocator)).setCharset(charset);
                }
            }
            try {
                IDigest digest = ArgTools.getDigest(tempArgs, "hash");
                LocatorTools.checkHash(resultLocator, digest);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("hash", e);
            }
            return resultLocator;
        }
        if (value instanceof byte[]) {
            return new ByteArrayLocator((byte[])value, "locator.bytes");
        }
        if (factory == null) {
            factory = LocatorFactory.get();
        }
        if (value instanceof File) {
            try {
                return factory.createLocator(((File)value).getAbsolutePath());
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        if (value instanceof String) {
            if (StringTools.isEmpty((String)value)) {
                return defaultValue;
            }
            try {
                return factory.createLocator((String)value);
            }
            catch (IOException e) {
                return defaultValue;
            }
        }
        try {
            return ConverterRegistry.get().convert(value, ILocator.class);
        }
        catch (ConversionException e) {
            return defaultValue;
        }
    }

    public static ILocator[] createLocators(String paths, ILocatorFactory factory) throws IOException {
        if (factory == null) {
            factory = LocatorFactory.get();
        }
        ArrayList<ILocator> locators = new ArrayList<ILocator>();
        StringTokenizer t = new StringTokenizer(paths, PATH_SEPARATOR);
        while (t.hasMoreTokens()) {
            String path = t.nextToken();
            locators.add(factory.createLocator(path));
        }
        ILocator[] result = new ILocator[locators.size()];
        return locators.toArray(result);
    }

    public static File createTempFile(ILocator locator) throws IOException {
        File tempFile = FileTools.createTempFile(locator.getTypedName());
        LocatorTools.save(locator, tempFile);
        return tempFile;
    }

    public static ILocator createTempLocator(ILocator locator) throws IOException {
        return LocatorTools.createTempLocator(locator, false);
    }

    public static ILocator createTempLocator(ILocator locator, boolean keepName) throws IOException {
        if (locator.getLength() != -1L && locator.getLength() < 5000L) {
            byte[] bytes = LocatorTools.getBytes(locator);
            return new ByteArrayLocator(bytes, locator.getTypedName());
        }
        File tempFile = FileTools.createTempFile(locator.getTypedName());
        LocatorTools.save(locator, tempFile);
        if (keepName) {
            return new RenamedLocator(new FileLocator(tempFile), locator.getFullName());
        }
        return new FileLocator(tempFile);
    }

    public static IDigest digest(ILocator locator, IDigester digester) throws IOException {
        InputStream is = locator.getInputStream();
        try {
            IDigest iDigest = DigestTools.digest(digester, is);
            return iDigest;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static IDigest digest(ILocator locator, String algorithmName) throws IOException {
        try {
            IDigester digester = DigestTools.createDigester(algorithmName);
            return LocatorTools.digest(locator, digester);
        }
        catch (NoSuchAlgorithmException e) {
            throw ExceptionTools.createIOException(e.getMessage(), e);
        }
    }

    public static byte[] getBytes(ILocator locator) throws IOException {
        if (locator == null) {
            return null;
        }
        if (locator instanceof ByteArrayLocator) {
            return ((ByteArrayLocator)locator).getBytes();
        }
        InputStream is = null;
        try {
            is = locator.getInputStream();
            byte[] byArray = StreamTools.toByteArray(is);
            return byArray;
        }
        finally {
            StreamTools.close(is);
        }
    }

    public static File getFile(ILocator locator) throws IOException {
        if (locator instanceof FileLocator) {
            return ((FileLocator)locator).getFile();
        }
        throw new IOException("can't create file for '" + locator.getFullName() + "'");
    }

    public static String getString(ILocator locator) throws IOException {
        if (locator instanceof StringLocator) {
            return ((StringLocator)locator).getContent();
        }
        Reader r = null;
        try {
            r = locator.getReader();
            String string = StreamTools.toString(r);
            return string;
        }
        finally {
            StreamTools.close(r);
        }
    }

    public static String getString(ILocator locator, String defaultCharsetName, int size) throws IOException {
        String string;
        if (locator instanceof StringLocator) {
            return ((StringLocator)locator).getContent();
        }
        BufferedInputStream is = null;
        TaggedReader r = null;
        try {
            is = new BufferedInputStream(locator.getInputStream(), size);
            if (defaultCharsetName == null && locator instanceof ICharsetSupport) {
                defaultCharsetName = ((ICharsetSupport)((Object)locator)).getCharset();
            }
            r = ReaderTools.createTaggedReader(is, defaultCharsetName, size);
            string = StreamTools.toString(r);
        }
        catch (Throwable throwable) {
            StreamTools.close(r);
            StreamTools.close(is);
            throw throwable;
        }
        StreamTools.close(r);
        StreamTools.close(is);
        return string;
    }

    public static void putBytes(ILocator locator, byte[] bytes) throws IOException {
        if (locator == null) {
            return;
        }
        OutputStream os = null;
        try {
            os = locator.getOutputStream();
            StreamTools.putBytes(os, bytes);
        }
        finally {
            StreamTools.close(os);
        }
    }

    public static void putString(ILocator locator, String string) throws IOException {
        if (locator == null) {
            return;
        }
        Writer w = null;
        try {
            w = locator.getWriter();
            w.write(string);
        }
        finally {
            StreamTools.close(w);
        }
    }

    public static void save(ILocator locator, File file) throws IOException {
        if (file.isDirectory()) {
            file = new File(file, locator.getTypedName());
        }
        InputStream is = null;
        FileOutputStream os = null;
        try {
            is = locator.getInputStream();
            os = new FileOutputStream(file);
            StreamTools.copyStream(is, false, os, false);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
    }

    private LocatorTools() {
    }
}

