/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.CommonLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class LookupLocatorFactory
extends CommonLocatorFactory {
    private List<ILocatorFactory> factories = new ArrayList<ILocatorFactory>();

    public boolean addLocatorFactory(ILocatorFactory factory) {
        if (factory == this) {
            throw new IllegalArgumentException("can not delegate to myself");
        }
        return this.factories.add(factory);
    }

    @Override
    protected ILocator basicCreateLocator(String location) throws IOException {
        ILocator current = null;
        for (ILocatorFactory factory : this.factories) {
            try {
                current = factory.createLocator(location);
                if (current == null || !current.exists()) continue;
                return current;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException("resource lookup '" + location + "' failed ('" + e.getMessage() + ")");
            }
        }
        if (current != null) {
            return current;
        }
        throw new FileNotFoundException("'" + location + "' not found");
    }

    public void clear() {
        this.factories.clear();
    }

    public List<ILocatorFactory> getLocatorFactories() {
        return new ArrayList<ILocatorFactory>(this.factories);
    }

    public boolean removeLocatorFactory(ILocatorFactory factory) {
        return this.factories.remove(factory);
    }
}

