/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.DelegatingLocatorFactory;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.LookupLocatorFactory;
import de.intarsys.tools.locator.RelativeLocatorFactory;
import java.io.File;
import java.util.StringTokenizer;

public class SearchPathLocatorFactory
extends DelegatingLocatorFactory
implements IElementConfigurable,
IContextSupport {
    public static final String PATH_SEPARATOR = ";";
    public static final String EA_SEARCHPATH = "searchpath";
    private String searchpath;

    public SearchPathLocatorFactory() {
        super(new LookupLocatorFactory());
    }

    protected void addSearchPath(File parent, String path) {
        File child = FileTools.resolvePath(parent, path);
        FileLocator locator = new FileLocator(child);
        locator.setSynchSynchronous(true);
        ((LookupLocatorFactory)this.getFactory()).addLocatorFactory(new RelativeLocatorFactory(locator));
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.searchpath = element.attributeValue(EA_SEARCHPATH, null);
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        if (context instanceof IFileEnvironment) {
            File parent = ((IFileEnvironment)context).getBaseDir();
            this.setSearchPath(parent, this.searchpath);
        }
    }

    public void setSearchPath(File parent, String paths) {
        ((LookupLocatorFactory)this.getFactory()).clear();
        StringTokenizer e = new StringTokenizer(paths, PATH_SEPARATOR);
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            if (path == null || path.trim().length() <= 0) continue;
            this.addSearchPath(parent, path);
        }
    }
}

