/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class StreamLocator
extends CommonLocator {
    private boolean inputUsed = false;
    private boolean outputUsed = false;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private String type;
    private String localName;

    public StreamLocator(InputStream is, OutputStream os, String name, String type) {
        this.inputStream = is;
        this.outputStream = os;
        this.localName = name;
        this.type = type;
    }

    public StreamLocator(InputStream stream, String name, String type) {
        this(stream, null, name, type);
    }

    public StreamLocator(OutputStream stream, String name, String type) {
        this(null, stream, name, type);
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.inputStream != null;
    }

    @Override
    public ILocator getChild(String child) {
        return null;
    }

    @Override
    public String getFullName() {
        return this.getLocalName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputUsed) {
            throw new IOException("input already requested");
        }
        this.inputUsed = true;
        return this.inputStream;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.outputUsed) {
            throw new IOException("output already requested");
        }
        this.outputUsed = true;
        return this.outputStream;
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.outputStream == null;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName);
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

