/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.charset.ICharsetAccess;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;

public class StringLocator
extends CommonLocator
implements ICharsetAccess {
    private final String content;
    private String charset = System.getProperty("file.encoding");
    private String fullName;
    private String localName;
    private String type;

    public StringLocator(String content, String pFullName) {
        this.content = content;
        this.setFullName(pFullName);
    }

    public StringLocator(String content, String pName, String pType) {
        this.content = content;
        if (StringTools.isEmpty(pType)) {
            this.setFullName(pName);
        } else {
            this.setFullName(String.valueOf(pName) + "." + pType);
        }
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return this.getContent() != null;
    }

    protected byte[] getBytes() {
        byte[] bytes;
        try {
            bytes = this.getContent().getBytes(this.charset);
        }
        catch (UnsupportedEncodingException e) {
            bytes = this.getContent().getBytes();
        }
        return bytes;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public ILocator getChild(String child) {
        return null;
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] bytes = this.getBytes();
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public long getLength() throws IOException {
        return this.getBytes().length;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        byte[] bytes = this.getBytes();
        return new RandomAccessByteArray(bytes);
    }

    @Override
    public Reader getReader() throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new StringReader(this.getContent());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return this.type == null ? this.localName : String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.setFullName(newName);
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    protected void setFullName(String newName) {
        this.fullName = newName;
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName, null, this.getType());
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

