/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public class TransientLocator
extends CommonLocator {
    private boolean alwaysUnchanged;
    private String localName;
    private String type;

    public TransientLocator(String name, String type) {
        if (name == null || type == null) {
            throw new NullPointerException("name and type may not be null for TransientLocator");
        }
        this.localName = name;
        this.type = this.canonical(type);
    }

    private String canonical(String name) {
        return name.trim().toLowerCase();
    }

    @Override
    public void delete() throws IOException {
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public ILocator getChild(String name) {
        return null;
    }

    @Override
    public String getFullName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getTypedName() {
        return String.valueOf(this.localName) + "." + this.type;
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        throw new FileNotFoundException("transient locator");
    }

    public boolean isAlwaysUnchanged() {
        return this.alwaysUnchanged;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    @Override
    public void rename(String newName) throws IOException {
        this.localName = FileTools.getBaseName(newName);
        this.type = FileTools.getExtension(newName);
    }

    public void setAlwaysUnchanged(boolean paramAlwaysUnchanged) {
        this.alwaysUnchanged = paramAlwaysUnchanged;
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }
}

