/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;

public class URLLocator
extends CommonLocator {
    private final URL url;
    private String encoding;
    private ILocator tempFileLocator;

    public URLLocator(URL url) {
        this.url = url;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof URLLocator)) {
            return false;
        }
        return this.url.equals(((URLLocator)obj).getUrl());
    }

    @Override
    public boolean exists() {
        try {
            URLConnection c = this.getUrl().openConnection();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public ILocator getChild(String childName) {
        return null;
    }

    protected String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getFullName() {
        return this.getUrl().toExternalForm();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getUrl().openStream();
    }

    @Override
    public String getLocalName() {
        return FileTools.getBaseName(this.getTypedName());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public synchronized IRandomAccess getRandomAccess() throws IOException {
        if (this.tempFileLocator == null) {
            this.tempFileLocator = this.createTempFileLocator();
        }
        return this.tempFileLocator.getRandomAccess();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.getEncoding() == null) {
            return new InputStreamReader(this.getInputStream());
        }
        return new InputStreamReader(this.getInputStream(), this.getEncoding());
    }

    @Override
    public Reader getReader(String newEncoding) throws IOException {
        if (newEncoding == null || newEncoding.equals("")) {
            return this.getReader();
        }
        return new InputStreamReader(this.getInputStream(), newEncoding);
    }

    @Override
    public String getType() {
        String path = this.getUrl().getPath();
        return FileTools.getExtension(path);
    }

    @Override
    public String getTypedName() {
        String path = this.getUrl().getPath();
        return FileTools.getFileName(path);
    }

    public URL getUrl() {
        return this.url;
    }

    @Override
    public Writer getWriter() throws IOException {
        throw new IOException("locator is read only");
    }

    @Override
    public Writer getWriter(String pEncoding) throws IOException {
        throw new IOException("locator is read only");
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    public boolean isSynchSynchronous() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return new ILocator[0];
    }

    protected void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void synch() {
    }

    public String toString() {
        return this.getUrl().toExternalForm();
    }

    @Override
    public URL toURL() {
        return this.getUrl();
    }
}

