/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.locator.CommonLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFileLocator
extends CommonLocator {
    private final ZipFile zipFile;
    private final String path;

    public ZipFileLocator(ILocator zipLocator, String path) {
        this.zipFile = new ZipFile(zipLocator);
        this.path = path;
    }

    protected ZipFileLocator(ZipFile zipFile, String path) {
        this.zipFile = zipFile;
        this.path = path;
    }

    @Override
    public boolean exists() {
        return false;
    }

    protected ZipEntry findEntry(String tempPath) throws IOException {
        for (ZipEntry entry : this.zipFile.getEntries()) {
            if (!entry.getName().equals(this.path)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public ILocator getChild(String name) {
        String tempPath = String.valueOf(this.path) + "/" + name;
        return new ZipFileLocator(this, tempPath);
    }

    @Override
    public String getFullName() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return null;
    }

    @Override
    public ILocator getParent() {
        return null;
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        return null;
    }

    @Override
    public Reader getReader() throws IOException {
        return null;
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getTypedName() {
        return null;
    }

    @Override
    public Writer getWriter() throws IOException {
        return null;
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return null;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        return null;
    }

    @Override
    public void synch() {
    }

    @Override
    public URL toURL() {
        return null;
    }

    static class ZipFile {
        private final ILocator zipLocator;
        private List<ZipEntry> entries;

        public ZipFile(ILocator zipLocator) {
            this.zipLocator = zipLocator;
        }

        protected List<ZipEntry> createEntries() throws IOException {
            ArrayList<ZipEntry> tempEntries = new ArrayList<ZipEntry>();
            InputStream is = this.zipLocator.getInputStream();
            try {
                ZipEntry entry;
                ZipInputStream zis = new ZipInputStream(is);
                while ((entry = zis.getNextEntry()) != null) {
                    tempEntries.add(entry);
                }
            }
            finally {
                StreamTools.close(is);
            }
            return tempEntries;
        }

        protected synchronized List<ZipEntry> getEntries() throws IOException {
            if (this.entries == null) {
                this.entries = this.createEntries();
            }
            return this.entries;
        }
    }
}

