/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator.trusted;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.trusted.TrustedLocator;
import de.intarsys.tools.locator.trusted.TrustedLocatorFactory;
import de.intarsys.tools.locking.ILock;
import de.intarsys.tools.locking.ILockLevel;
import de.intarsys.tools.locking.ILockSupport;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;

public class MemoryTrustedLocator
extends TrustedLocator {
    private SoftReference bytes;
    private ILock lock;
    private int lockCount = 0;

    public MemoryTrustedLocator(TrustedLocatorFactory factory, ILocator wrapped) {
        super(factory, wrapped);
    }

    protected synchronized void acquire() throws IOException {
        ILockSupport lockSupport;
        if (this.lockCount++ == 0 && (lockSupport = AdapterTools.getAdapter(this.getWrapped(), ILockSupport.class)) != null) {
            try {
                this.lock = lockSupport.getLock();
                this.lock.acquire(this, ILockLevel.SHARED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected byte[] basicGetBytes() {
        if (this.bytes == null) {
            return null;
        }
        return (byte[])this.bytes.get();
    }

    protected void basicSetBytes(byte[] pBytes) {
        this.bytes = new SoftReference<byte[]>(pBytes);
    }

    @Override
    protected ILocator createChildLocator(ILocator locator) {
        return new MemoryTrustedLocator(this.getFactory(), locator);
    }

    protected synchronized void dumpBytes(byte[] pBytes) throws IOException {
        this.basicSetBytes(pBytes);
        ByteArrayInputStream is = null;
        OutputStream os = null;
        try {
            is = new ByteArrayInputStream(pBytes);
            os = this.getWrapped().getOutputStream();
            StreamTools.copyStream(is, os);
        }
        catch (Throwable throwable) {
            StreamTools.close(is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close(is);
        StreamTools.close(os);
        this.initDigest();
    }

    protected synchronized byte[] getBytes() throws IOException {
        byte[] tempBytes = this.basicGetBytes();
        if (tempBytes == null) {
            if (this.getException() != null) {
                throw this.getException();
            }
            tempBytes = StreamTools.toByteArray(this.basicGetInputStream());
            this.basicSetBytes(tempBytes);
            if (this.getDigest() != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(tempBytes);
                IDigest newDigest = this.getFactory().createDigest(is);
                if (!this.getDigest().equals(newDigest)) {
                    throw new IOException("digest mismatch");
                }
            }
        }
        return tempBytes;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        byte[] tempBytes = this.getBytes();
        this.acquire();
        return new ByteArrayInputStream(tempBytes){
            private boolean closed;
            {
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                super.close();
                MemoryTrustedLocator.this.release();
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.acquire();
        return new ByteArrayOutputStream(){
            private boolean closed = false;

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                this.flush();
                super.close();
                MemoryTrustedLocator.this.release();
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                MemoryTrustedLocator.this.dumpBytes(this.toByteArray());
            }
        };
    }

    @Override
    public IRandomAccess getRandomAccess() throws IOException {
        byte[] tempBytes;
        try {
            tempBytes = this.getBytes();
        }
        catch (FileNotFoundException e) {
            tempBytes = null;
        }
        this.acquire();
        return new RandomAccessByteArray(tempBytes){
            private boolean changed;
            private boolean closed;
            {
                this.changed = false;
                this.closed = false;
            }

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                super.close();
                MemoryTrustedLocator.this.release();
            }

            @Override
            public void flush() throws IOException {
                super.flush();
                if (this.changed) {
                    this.changed = false;
                    MemoryTrustedLocator.this.dumpBytes(this.toByteArray());
                }
            }

            @Override
            public void setLength(long newLength) {
                this.changed = true;
                super.setLength(newLength);
            }

            @Override
            public void write(byte[] buffer) {
                this.changed = true;
                super.write(buffer);
            }

            @Override
            public void write(byte[] buffer, int start, int numBytes) {
                this.changed = true;
                super.write(buffer, start, numBytes);
            }

            @Override
            public void write(int b) {
                this.changed = true;
                super.write(b);
            }
        };
    }

    protected synchronized void release() {
        if (--this.lockCount == 0 && this.lock != null) {
            this.lock.release(this);
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [" + this.getWrapped() + "]";
    }
}

