/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator.trusted;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locator.trusted.ITrustedLocator;
import de.intarsys.tools.locator.trusted.TrustedLocatorFactory;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

public abstract class TrustedLocator
implements ILocator,
ITrustedLocator,
IAdapterSupport {
    private ILocator wrapped;
    private IDigest digest;
    private TrustedLocatorFactory factory;
    private IOException exception;

    public TrustedLocator(TrustedLocatorFactory factory, ILocator wrapped) {
        this.factory = factory;
        this.wrapped = wrapped;
        try {
            this.initDigest();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    protected InputStream basicGetDigestStream() throws IOException {
        return this.basicGetInputStream();
    }

    protected final InputStream basicGetInputStream() throws IOException {
        return this.getWrapped().getInputStream();
    }

    protected final OutputStream basicGetOutputStream() throws IOException {
        return this.getWrapped().getOutputStream();
    }

    protected final IRandomAccess basicGetRandomAccess() throws IOException {
        return this.getWrapped().getRandomAccess();
    }

    protected final Reader basicGetReader() throws IOException {
        return this.getWrapped().getReader();
    }

    protected final Reader basicGetReader(String encoding) throws IOException {
        return this.getWrapped().getReader(encoding);
    }

    protected final Writer basicGetWriter() throws IOException {
        return this.getWrapped().getWriter();
    }

    protected final Writer basicGetWriter(String encoding) throws IOException {
        return this.getWrapped().getWriter();
    }

    @Override
    public void checkpoint() throws IOException {
        if (this.getException() != null) {
            throw this.getException();
        }
        if (this.getDigest() == null) {
            return;
        }
        IDigest newDigest = this.factory.createDigest(this.basicGetDigestStream());
        if (!this.getDigest().equals(newDigest)) {
            throw new IOException("digest mismatch");
        }
    }

    protected abstract ILocator createChildLocator(ILocator var1);

    @Override
    public void delete() throws IOException {
        this.getWrapped().delete();
    }

    @Override
    public void ensureEqual(ILocator locator) throws IOException {
        if (this.getException() != null) {
            throw this.getException();
        }
        if (this.getDigest() == null) {
            return;
        }
        if (!(locator instanceof TrustedLocator)) {
            throw new IOException("uncomparable locators");
        }
        TrustedLocator other = (TrustedLocator)locator;
        if (other.getDigest() == null) {
            other.checkpoint();
        }
        if (!this.getDigest().equals(other.getDigest())) {
            throw new IOException("digest mismatch");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TrustedLocator)) {
            return false;
        }
        return this.getWrapped().equals(((TrustedLocator)obj).getWrapped());
    }

    @Override
    public boolean exists() {
        return this.getWrapped().exists();
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        return AdapterTools.getAdapter(this.wrapped, clazz);
    }

    @Override
    public ILocator getChild(String name) {
        ILocator child = this.getWrapped().getChild(name);
        if (child == null) {
            return null;
        }
        return this.createChildLocator(child);
    }

    protected IDigest getDigest() {
        return this.digest;
    }

    public IOException getException() {
        return this.exception;
    }

    public TrustedLocatorFactory getFactory() {
        return this.factory;
    }

    @Override
    public String getFullName() {
        return this.getWrapped().getFullName();
    }

    @Override
    public long getLength() throws IOException {
        return this.getWrapped().getLength();
    }

    @Override
    public String getLocalName() {
        return this.getWrapped().getLocalName();
    }

    @Override
    public ILocator getParent() {
        ILocator parent = this.getWrapped().getParent();
        if (parent == null) {
            return null;
        }
        return this.createChildLocator(parent);
    }

    @Override
    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getInputStream());
    }

    @Override
    public Reader getReader(String encoding) throws IOException {
        return new InputStreamReader(this.getInputStream(), encoding);
    }

    @Override
    public String getType() {
        return this.getWrapped().getType();
    }

    @Override
    public String getTypedName() {
        return this.getWrapped().getTypedName();
    }

    public ILocator getWrapped() {
        return this.wrapped;
    }

    @Override
    public Writer getWriter() throws IOException {
        return new OutputStreamWriter(this.getOutputStream());
    }

    @Override
    public Writer getWriter(String encoding) throws IOException {
        return new OutputStreamWriter(this.getOutputStream(), encoding);
    }

    public int hashCode() {
        return this.getWrapped().hashCode();
    }

    protected void initDigest() throws IOException {
        if (this.wrapped.isDirectory()) {
            return;
        }
        this.digest = this.factory.createDigest(this.basicGetDigestStream());
    }

    @Override
    public boolean isDirectory() {
        return this.getWrapped().isDirectory();
    }

    @Override
    public boolean isOutOfSynch() {
        return this.getWrapped().isOutOfSynch();
    }

    @Override
    public boolean isReadOnly() {
        return this.getWrapped().isReadOnly();
    }

    @Override
    public ILocator[] listLocators(ILocatorNameFilter filter) throws IOException {
        ILocator[] children = this.getWrapped().listLocators(filter);
        ILocator[] result = new ILocator[children.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.createChildLocator(children[i]);
            ++i;
        }
        return result;
    }

    @Override
    public void rename(String newName) throws IOException {
        this.getWrapped().rename(newName);
    }

    @Override
    public void setReadOnly() {
        this.getWrapped().setReadOnly();
    }

    @Override
    public void synch() {
        this.getWrapped().synch();
    }

    @Override
    public URL toURL() {
        return this.getWrapped().toURL();
    }
}

