/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.logging.IDumpObject;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class CommonDumpObject
implements IDumpObject {
    @Override
    public List<String> dump(String prefix, Object object, IDumpObject details) {
        ArrayList<String> result = new ArrayList<String>();
        if (object instanceof byte[]) {
            byte[] array = (byte[])object;
            String hex = array.length > 50 ? String.valueOf(HexTools.bytesToHexString(array, 0, 49)) + "..." : HexTools.bytesToHexString(array);
            result.add(String.valueOf(prefix) + "byte[" + array.length + "] " + hex);
        } else if (object instanceof char[]) {
            result.add(String.valueOf(prefix) + "a character array");
        } else if (object instanceof IValueHolder) {
            IValueHolder ref = (IValueHolder)object;
            List<String> attrValue = details.dump("", ref.get(), details);
            Iterator<String> it = attrValue.iterator();
            result.add(String.valueOf(prefix) + "a reference to " + it.next());
            while (it.hasNext()) {
                result.add(String.valueOf(prefix) + it.next());
            }
        } else if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            result.add(String.valueOf(prefix) + "[");
            Object[] objectArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                result.addAll(details.dump(String.valueOf(prefix) + "    ", element, details));
                ++n2;
            }
            result.add(String.valueOf(prefix) + "]");
        } else if (object instanceof int[]) {
            int[] array = (int[])object;
            result.add(String.valueOf(prefix) + Arrays.toString(array));
        } else if (object instanceof Integer) {
            int i = (Integer)object;
            result.add(String.valueOf(prefix) + i + " | 0x" + Integer.toHexString(i));
        } else if (object instanceof Byte) {
            byte i = (Byte)object;
            result.add(String.valueOf(prefix) + i + " | 0x" + Integer.toHexString(i));
        } else {
            result.add(String.valueOf(prefix) + StringTools.safeString(object));
        }
        return result;
    }
}

