/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class CompositeHandler
extends Handler {
    private List<Handler> handlers = new ArrayList<Handler>();

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    @Override
    public void close() throws SecurityException {
        for (Handler handler : this.handlers) {
            handler.close();
        }
    }

    @Override
    public void flush() {
        for (Handler handler : this.handlers) {
            handler.flush();
        }
    }

    public Handler[] getHandlers() {
        return this.handlers.toArray(new Handler[this.handlers.size()]);
    }

    @Override
    public void publish(LogRecord record) {
        for (Handler handler : this.handlers) {
            handler.publish(record);
        }
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }
}

