/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class FileDumpHandler
extends Handler {
    private static final Logger Log = LogTools.getLogger(FileDumpHandler.class);
    private File directory;

    public static void dump(File logDir, Object target) throws IOException, FileNotFoundException {
        FileTools.checkDirectory(logDir, true, true, true);
        if (target instanceof Attachment) {
            target = ((Attachment)target).getAttached();
        }
        if (target instanceof ILocator) {
            LocatorTools.save((ILocator)target, logDir);
        } else if (target instanceof ILocatorSupport) {
            LocatorTools.save(((ILocatorSupport)target).getLocator(), logDir);
        } else if (target instanceof File) {
            FileTools.copyFile((File)target, logDir);
        } else {
            if (target instanceof InputStream) {
                try {
                    File tempFile = File.createTempFile("dump", ".bytes", logDir);
                    FileOutputStream os = new FileOutputStream(tempFile);
                    StreamTools.copyStream((InputStream)target, false, os, true);
                }
                finally {
                    StreamTools.close((InputStream)target);
                }
            }
            if (target instanceof byte[]) {
                File tempFile = File.createTempFile("dump", ".bytes", logDir);
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(tempFile);
                    ((OutputStream)os).write((byte[])target);
                }
                catch (Throwable throwable) {
                    StreamTools.close(os);
                    throw throwable;
                }
                StreamTools.close(os);
            }
        }
    }

    public FileDumpHandler() {
        this.init();
    }

    @Override
    public void close() throws SecurityException {
    }

    protected void dumpFile(Object target) throws IOException {
        File logDir = this.getDirectory();
        FileDumpHandler.dump(logDir, target);
    }

    @Override
    public void flush() {
    }

    public File getDirectory() {
        return this.directory;
    }

    private void init() {
        String cname;
        LogManager manager = LogManager.getLogManager();
        String tempValue = manager.getProperty(String.valueOf(cname = this.getClass().getName()) + ".directory");
        if (StringTools.isEmpty(tempValue)) {
            tempValue = "${environment.profiledir}/dumplog.${system.uniquetime:d}";
            try {
                tempValue = (String)TemplateEvaluator.get().evaluate(tempValue, Args.create());
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
            tempValue = FileTools.trimPath(tempValue);
            this.directory = new File(tempValue);
        }
        if ((tempValue = manager.getProperty(String.valueOf(cname) + ".level")) == null) {
            this.setLevel(Level.ALL);
        } else {
            try {
                this.setLevel(Level.parse(tempValue.trim()));
            }
            catch (Exception ex) {
                this.setLevel(Level.ALL);
            }
        }
    }

    @Override
    public void publish(LogRecord record) {
        Object[] parameters = record.getParameters();
        if (parameters != null && parameters.length > 0) {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                FileTools.checkDirectory(this.directory, true, true, true);
                Object[] objectArray = parameters;
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    Object target = objectArray[n2];
                    this.dumpFile(target);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }
}

