/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.logging.CommonHandlerFactory;
import de.intarsys.tools.logging.FileDumpHandler;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.util.logging.Handler;

public class FileDumpHandlerFactory
extends CommonHandlerFactory {
    private String directoryName = "dumplog.${system.uniquetime:d}";
    private IStringEvaluator templateEvaluator;

    @Override
    protected Handler basicCreateHandler() {
        FileDumpHandler tempHandler = new FileDumpHandler();
        tempHandler.setDirectory(this.getDirectory());
        return tempHandler;
    }

    public File getDirectory() {
        String tempName = this.getDirectoryName();
        if (StringTools.isEmpty(tempName)) {
            tempName = "dumplog.${system.uniquetime:d}";
        }
        try {
            tempName = (String)this.getTemplateEvaluator().evaluate(tempName, Args.create());
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
        tempName = FileTools.trimPath(tempName);
        File parent = FileEnvironment.get().getProfileDir();
        return FileTools.resolvePath(parent, tempName);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public IStringEvaluator getTemplateEvaluator() {
        if (this.templateEvaluator == null) {
            return TemplateEvaluator.get();
        }
        return this.templateEvaluator;
    }

    public void setDirectoryName(String fileDumpHandlerDirName) {
        this.directoryName = fileDumpHandlerDirName;
    }

    public void setTemplateEvaluator(IStringEvaluator stringEvaluator) {
        this.templateEvaluator = stringEvaluator;
    }
}

