/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.logging.XMLFormatter;

public class FileHandler
extends StreamHandler {
    private MeteredStream meter;
    private boolean append;
    private int limit;
    private int count;
    private String pattern;
    private String lockFileName;
    private FileOutputStream lockStream;
    private File[] files;
    private static final int MAX_LOCKS = 100;
    private static HashMap locks = new HashMap();

    public FileHandler() throws IOException, SecurityException {
        this.configure();
        this.openFiles();
    }

    public FileHandler(String pattern) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.openFiles();
    }

    public FileHandler(String pattern, boolean append) throws IOException, SecurityException {
        if (pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = 0;
        this.count = 1;
        this.append = append;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.openFiles();
    }

    public FileHandler(String pattern, int limit, int count, boolean append) throws IOException, SecurityException {
        if (limit < 0 || count < 1 || pattern.length() < 1) {
            throw new IllegalArgumentException();
        }
        this.configure();
        this.pattern = pattern;
        this.limit = limit;
        this.count = count;
        this.append = append;
        this.openFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws SecurityException {
        super.close();
        if (this.lockFileName == null) {
            return;
        }
        try {
            this.lockStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap hashMap = locks;
        synchronized (hashMap) {
            locks.remove(this.lockFileName);
        }
        new File(this.lockFileName).delete();
        this.lockFileName = null;
        this.lockStream = null;
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.pattern = this.getStringProperty(String.valueOf(cname) + ".pattern", "%h/java%u.log");
        this.limit = this.getIntProperty(String.valueOf(cname) + ".limit", 0);
        if (this.limit < 0) {
            this.limit = 0;
        }
        this.count = this.getIntProperty(String.valueOf(cname) + ".count", 1);
        if (this.count <= 0) {
            this.count = 1;
        }
        this.append = this.getBooleanProperty(String.valueOf(cname) + ".append", false);
        this.setLevel(this.getLevelProperty(String.valueOf(cname) + ".level", Level.ALL));
        this.setFilter(this.getFilterProperty(String.valueOf(cname) + ".filter", null));
        this.setFormatter(this.getFormatterProperty(String.valueOf(cname) + ".formatter", new XMLFormatter()));
        try {
            this.setEncoding(this.getStringProperty(String.valueOf(cname) + ".encoding", null));
        }
        catch (Exception ex) {
            try {
                this.setEncoding(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private File generate(String pattern, int generation, int unique) throws IOException {
        File file = null;
        String word = "";
        int ix = 0;
        boolean sawg = false;
        boolean sawu = false;
        while (ix < pattern.length()) {
            char ch = pattern.charAt(ix);
            char ch2 = '\u0000';
            if (++ix < pattern.length()) {
                ch2 = Character.toLowerCase(pattern.charAt(ix));
            }
            if (ch == '/') {
                if (file == null) {
                    if (ch2 == '/') {
                        word = "//";
                        ++ix;
                    }
                    file = new File(word);
                } else {
                    file = new File(file, word);
                }
                word = "";
                continue;
            }
            if (ch == '%') {
                if (ch2 == 't') {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    if (tmpDir == null) {
                        tmpDir = System.getProperty("user.home");
                    }
                    file = new File(tmpDir);
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'h') {
                    file = new File(System.getProperty("user.home"));
                    ++ix;
                    word = "";
                    continue;
                }
                if (ch2 == 'g') {
                    word = String.valueOf(word) + generation;
                    sawg = true;
                    ++ix;
                    continue;
                }
                if (ch2 == 'u') {
                    word = String.valueOf(word) + unique;
                    sawu = true;
                    ++ix;
                    continue;
                }
                if (ch2 == '%') {
                    word = String.valueOf(word) + "%";
                    ++ix;
                    continue;
                }
            }
            word = String.valueOf(word) + ch;
        }
        if (this.count > 1 && !sawg) {
            word = String.valueOf(word) + "." + generation;
        }
        if (unique > 0 && !sawu) {
            word = String.valueOf(word) + "." + unique;
        }
        if (word.length() > 0) {
            file = file == null ? new File(word) : new File(file, word);
        }
        return file;
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    protected String getProperty(String name) {
        return LogManager.getLogManager().getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    private void open(File fname, boolean append) throws IOException {
        int len = 0;
        if (append) {
            len = (int)fname.length();
        }
        FileOutputStream fout = new FileOutputStream(fname.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.meter = new MeteredStream(bout, len);
        this.setOutputStream(this.meter);
    }

    /*
     * Exception decompiling
     */
    private void openFiles() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        super.publish(record);
        this.flush();
        if (this.limit > 0 && this.meter.written >= this.limit) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    FileHandler.this.rotate();
                    return null;
                }
            });
        }
    }

    private synchronized void rotate() {
        Level oldLevel = this.getLevel();
        this.setLevel(Level.OFF);
        super.close();
        int i = this.count - 2;
        while (i >= 0) {
            File f1 = this.files[i];
            File f2 = this.files[i + 1];
            if (f1.exists()) {
                if (f2.exists()) {
                    f2.delete();
                }
                f1.renameTo(f2);
            }
            --i;
        }
        try {
            this.open(this.files[0], false);
        }
        catch (IOException ix) {
            this.reportError(null, ix, 4);
        }
        this.setLevel(oldLevel);
    }

    private static class InitializationErrorManager
    extends ErrorManager {
        Exception lastException;

        private InitializationErrorManager() {
        }

        @Override
        public void error(String msg, Exception ex, int code) {
            this.lastException = ex;
        }
    }

    private static class MeteredStream
    extends OutputStream {
        OutputStream out;
        int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }
    }
}

