/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.logging.CommonHandlerFactory;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;

public class FileHandlerFactory
extends CommonHandlerFactory {
    private File file;
    private String fileName = "log.%u.%g.log";
    private int count = 5;
    private int limit = 1000000;
    private IStringEvaluator templateEvaluator;
    private boolean append = false;

    @Override
    protected Handler basicCreateHandler() throws IOException {
        File logFile = this.getFile();
        FileHandler tempHandler = new FileHandler(logFile.getAbsolutePath(), this.getLimit(), this.getCount(), this.isAppend());
        return tempHandler;
    }

    public int getCount() {
        return this.count;
    }

    public File getFile() {
        if (this.file != null) {
            return this.file;
        }
        String tempName = this.getFileName();
        if (StringTools.isEmpty(tempName)) {
            tempName = "log.%u.%g.log";
        }
        try {
            tempName = (String)this.getTemplateEvaluator().evaluate(tempName, Args.create());
        }
        catch (Exception exception) {
            // empty catch block
        }
        tempName = FileTools.trimPath(tempName);
        File parent = FileEnvironment.get().getProfileDir();
        File tempFile = FileTools.resolvePath(parent, tempName);
        if (tempFile.getParentFile() != null) {
            tempFile.getParentFile().mkdirs();
        }
        return tempFile;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLimit() {
        return this.limit;
    }

    public IStringEvaluator getTemplateEvaluator() {
        if (this.templateEvaluator == null) {
            return TemplateEvaluator.get();
        }
        return this.templateEvaluator;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setCount(int fileHandlerCount) {
        this.count = fileHandlerCount;
        this.setSingletonHandler(null);
    }

    public void setFile(File fileHandlerFile) {
        this.file = fileHandlerFile;
        this.setSingletonHandler(null);
    }

    public void setFileName(String filename) {
        this.fileName = filename;
        this.setSingletonHandler(null);
    }

    public void setLimit(int fileHandlerLimit) {
        this.limit = fileHandlerLimit;
        this.setSingletonHandler(null);
    }

    public void setTemplateEvaluator(IStringEvaluator stringEvaluator) {
        this.templateEvaluator = stringEvaluator;
        this.setSingletonHandler(null);
    }
}

