/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.DelegatingHandler;
import de.intarsys.tools.logging.IHandlerFactory;
import de.intarsys.tools.logging.ThreadFilter;
import java.io.IOException;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandlerSwitcher {
    private Handler handler;
    private boolean handlerPerAttach = false;
    private IHandlerFactory handlerFactory;
    private String loggerName = "";
    private final Handler handlerAttached = new DelegatingHandler(){

        @Override
        public Handler getBaseHandler() {
            return LogHandlerSwitcher.this.handler;
        }

        @Override
        public Filter getFilter() {
            return LogHandlerSwitcher.this.filter;
        }

        @Override
        public void publish(LogRecord record) {
            LogHandlerSwitcher.this.basicPublishAttached(record);
        }
    };
    private final Handler handlerDetached = new DelegatingHandler(){

        @Override
        public Handler getBaseHandler() {
            return LogHandlerSwitcher.this.handler;
        }

        @Override
        public void publish(LogRecord record) {
            LogHandlerSwitcher.this.basicPublishDetached(record);
        }
    };
    private ThreadFilter filter = new ThreadFilter(false);
    private int attachCounter = 0;

    public void attach() {
        this.getFilter().activate();
        if (this.attachCounter++ == 0) {
            if (this.isHandlerPerAttach() || this.handler == null) {
                this.switchLog();
            }
            Logger.getLogger(this.getLoggerName()).addHandler(this.getHandlerAttached());
        }
    }

    protected void basicPublishAttached(LogRecord record) {
        if (this.handler == null) {
            return;
        }
        if (this.getFilter().isActive()) {
            this.handler.publish(record);
        }
    }

    protected void basicPublishDetached(LogRecord record) {
        if (this.handler == null) {
            return;
        }
        if (!this.getFilter().isActive()) {
            this.handler.publish(record);
        }
    }

    protected Handler createLogHandler() throws IOException {
        if (this.handlerFactory == null) {
            return null;
        }
        return this.handlerFactory.createLogHandler();
    }

    public void destroy() {
        if (this.handler != null) {
            this.handler.close();
            this.handler = null;
        }
    }

    public void detach() {
        this.getFilter().deactivate();
        if (--this.attachCounter == 0) {
            Logger.getLogger(this.getLoggerName()).removeHandler(this.getHandlerAttached());
        }
    }

    protected ThreadFilter getFilter() {
        return this.filter;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public Handler getHandlerAttached() {
        return this.handlerAttached;
    }

    public Handler getHandlerDetached() {
        return this.handlerDetached;
    }

    public IHandlerFactory getHandlerFactory() {
        return this.handlerFactory;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void init() throws IOException {
        if (!this.isHandlerPerAttach()) {
            this.switchLog();
        }
    }

    public boolean isHandlerPerAttach() {
        return this.handlerPerAttach;
    }

    public void setHandlerFactory(IHandlerFactory logHandlerFactory) {
        this.handlerFactory = logHandlerFactory;
    }

    public void setHandlerPerAttach(boolean logPerRequest) {
        this.handlerPerAttach = logPerRequest;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }

    protected void switchLog() {
        if (this.handler != null) {
            this.handler.close();
        }
        try {
            this.handler = this.createLogHandler();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

