/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.CommonDumpObject;
import de.intarsys.tools.logging.CompositeHandler;
import de.intarsys.tools.logging.DelegatingHandler;
import de.intarsys.tools.logging.FileHandler;
import de.intarsys.tools.logging.IDumpObject;
import de.intarsys.tools.logging.LogConfigurator;
import de.intarsys.tools.logging.ThreadFilter;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LogTools {
    private static IDumpObject DumpObject = new CommonDumpObject();
    public static final String INDENT = "    ";

    public static void closeFileLogger(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            handlers[i].close();
            ++i;
        }
    }

    public static Logger createFileLogger(String id, String filePattern, boolean append) throws SecurityException, IOException {
        Logger logger = Logger.getLogger(id);
        java.util.logging.FileHandler handler = new java.util.logging.FileHandler(filePattern, append);
        logger.addHandler(handler);
        return logger;
    }

    public static void dumpLogFiles() {
        File[] files;
        File[] fileArray = files = LogTools.getFilesThreadLocal();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                Logger.getLogger("").log(Level.WARNING, "dump " + file.getAbsolutePath(), file);
            }
            ++n2;
        }
    }

    public static List<String> dumpObject(String prefix, Object object) {
        return LogTools.dumpObject(prefix, object, DumpObject);
    }

    public static List<String> dumpObject(String prefix, Object object, IDumpObject details) {
        return DumpObject.dump(prefix, object, details);
    }

    public static File[] getFiles(Handler handler) {
        try {
            handler.flush();
            Field field = java.util.logging.FileHandler.class.getDeclaredField("files");
            field.setAccessible(true);
            return (File[])field.get(handler);
        }
        catch (Exception e) {
            return new File[0];
        }
    }

    public static File[] getFilesThreadLocal() {
        ArrayList<File> files = new ArrayList<File>();
        Logger logger = Logger.getLogger("");
        Handler[] handlers = logger.getHandlers();
        LogTools.getFilesThreadLocal(handlers, files);
        return files.toArray(new File[files.size()]);
    }

    protected static void getFilesThreadLocal(Handler handler, List<File> files) {
        if (handler == null) {
            return;
        }
        Filter filter = handler.getFilter();
        if (filter instanceof ThreadFilter && !((ThreadFilter)filter).isActive()) {
            return;
        }
        if (handler instanceof java.util.logging.FileHandler) {
            files.addAll(Arrays.asList(LogTools.getFiles(handler)));
        } else if (handler instanceof CompositeHandler) {
            LogTools.getFilesThreadLocal(((CompositeHandler)handler).getHandlers(), files);
        } else if (handler instanceof DelegatingHandler) {
            LogTools.getFilesThreadLocal(((DelegatingHandler)handler).getBaseHandler(), files);
        }
    }

    protected static void getFilesThreadLocal(Handler[] handlers, List<File> files) {
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            LogTools.getFilesThreadLocal(handler, files);
            ++n2;
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        Logger logger = Logger.getLogger(LogTools.toLoggerName(clazz));
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static Logger getLogger(String name) {
        Logger logger = Logger.getLogger(name);
        LogConfigurator.get().configure(logger);
        return logger;
    }

    public static void reconfigure(ClassLoader classloader, String resource) {
        InputStream is;
        block13: {
            is = null;
            try {
                try {
                    is = classloader.getResourceAsStream(resource);
                    if (is != null) {
                        LogManager.getLogManager().readConfiguration(is);
                    }
                }
                catch (Exception exception) {
                    StreamTools.close(is);
                    break block13;
                }
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                throw throwable;
            }
            StreamTools.close(is);
        }
        try {
            try {
                is = classloader.getResourceAsStream(resource);
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.endsWith(".level")) continue;
                        String logger = key.substring(0, key.length() - 6);
                        Logger.getLogger(logger);
                    }
                }
            }
            catch (Exception exception) {
                StreamTools.close(is);
            }
        }
        finally {
            StreamTools.close(is);
        }
    }

    protected static void setFileHandlerLevel(Handler handler, Level newLevel) {
        if (handler instanceof java.util.logging.FileHandler || handler instanceof FileHandler) {
            handler.setLevel(newLevel);
        } else if (handler instanceof CompositeHandler) {
            LogTools.setFileHandlerLevel(((CompositeHandler)handler).getHandlers(), newLevel);
        } else if (handler instanceof DelegatingHandler) {
            LogTools.setFileHandlerLevel(((DelegatingHandler)handler).getBaseHandler(), newLevel);
        }
    }

    protected static void setFileHandlerLevel(Handler[] handlers, Level newLevel) {
        Handler[] handlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            LogTools.setFileHandlerLevel(handler, newLevel);
            ++n2;
        }
    }

    public static void setFileHandlerLevel(Logger logger, Level newLevel) {
        logger.setLevel(newLevel);
        Handler[] handlers = logger.getHandlers();
        LogTools.setFileHandlerLevel(handlers, newLevel);
    }

    public static String toLoggerName(Class<?> clazz) {
        String result = clazz.getName();
        int index = result.lastIndexOf(46);
        if (index > -1) {
            result = result.substring(0, index);
        }
        return result;
    }

    private LogTools() {
    }
}

