/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.logging.SimpleFormatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MemoryLogHandler
extends Handler
implements INotificationSupport {
    private static final int DEFAULT_SIZE = 1000;
    private final int size;
    private final String id;
    private final LogRecord[] buffer;
    private int start;
    private int count;
    private EventDispatcher dispatcher;

    public MemoryLogHandler(String id) {
        this.size = 1000;
        this.id = id;
        this.setFormatter(new SimpleFormatter());
        this.buffer = new LogRecord[this.size];
        this.start = 0;
        this.count = 0;
    }

    public MemoryLogHandler(String id, int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.size = size;
        this.id = id;
        this.setFormatter(new SimpleFormatter());
        this.buffer = new LogRecord[size];
        this.start = 0;
        this.count = 0;
    }

    @Override
    public synchronized void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.buffer.length) {
            this.buffer[i] = null;
            ++i;
        }
        this.start = 0;
        this.count = 0;
        this.triggerChanged(null, null, null);
    }

    @Override
    public void close() throws SecurityException {
        this.setLevel(Level.OFF);
    }

    @Override
    public void flush() {
    }

    public String getId() {
        return this.id;
    }

    public synchronized LogRecord[] getLogRecords() {
        LogRecord[] result = new LogRecord[this.count];
        int i = 0;
        while (i < this.count) {
            int ix = (this.start + i) % this.buffer.length;
            result[i] = this.buffer[ix];
            ++i;
        }
        return result;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized String getString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.count) {
            int ix = (this.start + i) % this.buffer.length;
            try {
                sb.append(this.getFormatter().format(this.buffer[ix]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        int ix = (this.start + this.count) % this.buffer.length;
        this.buffer[ix] = record;
        if (this.count < this.buffer.length) {
            ++this.count;
        } else {
            ++this.start;
            this.start %= this.buffer.length;
        }
        this.triggerChanged(null, null, record);
    }

    public synchronized void publishTo(Handler target) {
        int i = 0;
        while (i < this.count) {
            int ix = (this.start + i) % this.buffer.length;
            target.publish(this.buffer[ix]);
            ++i;
        }
        this.clear();
    }

    public synchronized void publishTo(Logger target) {
        int i = 0;
        while (i < this.count) {
            int ix = (this.start + i) % this.buffer.length;
            target.log(this.buffer[ix]);
            ++i;
        }
        this.clear();
    }

    @Override
    public synchronized void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.dispatcher = null;
        }
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent(this, attribute, oldValue, newValue);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

