/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.MemoryLogHandler;
import java.util.HashMap;
import java.util.Map;

public class MemoryLogRegistry {
    private static final MemoryLogRegistry ACTIVE = new MemoryLogRegistry();
    private final Map<String, MemoryLogHandler> handlers = new HashMap<String, MemoryLogHandler>();

    public static MemoryLogRegistry get() {
        return ACTIVE;
    }

    public MemoryLogHandler[] getHandlers() {
        return this.handlers.values().toArray(new MemoryLogHandler[this.handlers.size()]);
    }

    public MemoryLogHandler lookup(String id) {
        return this.handlers.get(id);
    }

    public void register(MemoryLogHandler handler) {
        this.handlers.put(handler.getId(), handler);
    }

    public void unregister(MemoryLogHandler handler) {
        this.handlers.remove(handler.getId());
    }
}

