/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.format.TrivialDateFormat;
import de.intarsys.tools.logging.SDC;
import de.intarsys.tools.string.StringTools;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class SimpleFormatter
extends Formatter {
    private static final String LF = StringTools.LS;
    private Format dateFormat = new TrivialDateFormat();
    private final StringBuffer sb = new StringBuffer();
    private int widthSDC = 20;
    private boolean showDate = true;
    private boolean showLevel = true;
    private boolean showName = true;
    private boolean showSDC = false;
    private boolean showThread = true;
    private int widthLevel = 7;
    private int widthName = 30;
    private int widthThread = 15;

    static {
        new TrivialDateFormat();
        StringTools.isEmpty("");
        Calendar.getInstance();
        SDC.get();
    }

    public SimpleFormatter() {
        this.configure();
    }

    protected void configure() {
        String cname = this.getClass().getName();
        this.setShowSDC(this.getBooleanProperty(String.valueOf(cname) + ".sdc.show", this.isShowSDC()));
        this.setWidthSDC(this.getIntProperty(String.valueOf(cname) + ".sdc.width", this.getWidthSDC()));
        this.setShowThread(this.getBooleanProperty(String.valueOf(cname) + ".thread.show", this.isShowThread()));
        this.setWidthThread(this.getIntProperty(String.valueOf(cname) + ".thread.width", this.getWidthThread()));
        this.setShowDate(this.getBooleanProperty(String.valueOf(cname) + ".date.show", this.isShowDate()));
        this.setShowLevel(this.getBooleanProperty(String.valueOf(cname) + ".level.show", this.isShowLevel()));
        this.setWidthLevel(this.getIntProperty(String.valueOf(cname) + ".level.width", this.getWidthLevel()));
        this.setShowName(this.getBooleanProperty(String.valueOf(cname) + ".name.show", this.isShowName()));
        this.setWidthName(this.getIntProperty(String.valueOf(cname) + ".name.width", this.getWidthName()));
    }

    @Override
    public synchronized String format(LogRecord record) {
        int i;
        this.sb.setLength(0);
        if (this.isShowDate()) {
            this.sb.append("[");
            int index = this.sb.length();
            this.dateFormat.format(new Date(record.getMillis()), this.sb, null);
            i = this.sb.length() - index;
            while (i < 24) {
                this.sb.append(' ');
                ++i;
            }
            this.sb.append("]");
        }
        if (this.isShowLevel()) {
            this.sb.append("[");
            String levelString = record.getLevel().toString();
            this.sb.append(levelString);
            i = levelString.length();
            while (i < this.widthLevel) {
                this.sb.append(' ');
                ++i;
            }
            this.sb.append("]");
        }
        if (this.isShowName()) {
            String loggerString = record.getLoggerName();
            if (loggerString == null) {
                loggerString = "<unknown>";
            }
            if (loggerString.length() > this.widthName) {
                loggerString = StringTools.getTrailing(loggerString, this.widthName);
            }
            this.sb.append("[");
            this.sb.append(loggerString);
            i = loggerString.length();
            while (i < this.widthName) {
                this.sb.append(' ');
                ++i;
            }
            this.sb.append("]");
        }
        if (this.isShowThread()) {
            String threadString = Thread.currentThread().getName();
            if (threadString.length() > this.widthThread) {
                threadString = StringTools.getTrailing(threadString, this.widthThread);
            }
            this.sb.append("[");
            this.sb.append(threadString);
            i = threadString.length();
            while (i < this.widthThread) {
                this.sb.append(' ');
                ++i;
            }
            this.sb.append("]");
        }
        if (this.isShowSDC()) {
            this.sb.append("[");
            String sdcString = String.valueOf(SDC.get());
            this.sb.append(sdcString);
            i = sdcString.length();
            while (i < this.widthSDC) {
                this.sb.append(' ');
                ++i;
            }
            this.sb.append("]");
        }
        this.sb.append(" ");
        this.sb.append(record.getMessage());
        this.sb.append(LF);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                this.sb.append(sw.toString());
                this.sb.append(LF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.sb.toString();
    }

    protected boolean getBooleanProperty(String name, boolean defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String property = manager.getProperty(name);
        if (StringTools.isEmpty(property)) {
            return defaultValue;
        }
        return Boolean.valueOf(property.trim());
    }

    protected int getIntProperty(String name, int defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String property = manager.getProperty(name);
        if (StringTools.isEmpty(property)) {
            return defaultValue;
        }
        try {
            return Integer.valueOf(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getWidthLevel() {
        return this.widthLevel;
    }

    public int getWidthName() {
        return this.widthName;
    }

    public int getWidthSDC() {
        return this.widthSDC;
    }

    public int getWidthThread() {
        return this.widthThread;
    }

    public boolean isShowDate() {
        return this.showDate;
    }

    public boolean isShowLevel() {
        return this.showLevel;
    }

    public boolean isShowName() {
        return this.showName;
    }

    public boolean isShowSDC() {
        return this.showSDC;
    }

    public boolean isShowThread() {
        return this.showThread;
    }

    public void setShowDate(boolean showDate) {
        this.showDate = showDate;
    }

    public void setShowLevel(boolean showLevel) {
        this.showLevel = showLevel;
    }

    public void setShowName(boolean showName) {
        this.showName = showName;
    }

    public void setShowSDC(boolean showSDC) {
        this.showSDC = showSDC;
    }

    public void setShowThread(boolean showThread) {
        this.showThread = showThread;
    }

    public void setWidthLevel(int widthLevel) {
        this.widthLevel = widthLevel;
    }

    public void setWidthName(int widthLoggername) {
        this.widthName = widthLoggername;
    }

    public void setWidthSDC(int widthSDC) {
        this.widthSDC = widthSDC;
    }

    public void setWidthThread(int widthThread) {
        this.widthThread = widthThread;
    }
}

