/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

public class ThreadFilter
implements Filter {
    private ThreadLocal<Integer> threadActivation = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    public ThreadFilter(boolean activate) {
        if (activate) {
            this.activate();
        }
    }

    public boolean activate() {
        int tempActivation = this.threadActivation.get();
        this.threadActivation.set(tempActivation + 1);
        return tempActivation == 0;
    }

    public boolean deactivate() {
        int tempActivation = this.threadActivation.get();
        this.threadActivation.set(tempActivation - 1);
        return tempActivation == 1;
    }

    public boolean isActive() {
        return this.threadActivation.get() > 0;
    }

    @Override
    public boolean isLoggable(LogRecord record) {
        return this.threadActivation.get() > 0;
    }
}

