/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.macro;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.macro.MacroControlFlow;
import de.intarsys.tools.macro.MacroFunctor;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.string.StringTools;

public class MacroAssign<T>
extends MacroFunctor<T> {
    private IFunctor<T> valueExpression;
    private String assignTo;

    public MacroAssign() {
    }

    public MacroAssign(IFunctor<T> functor, String assignTo) {
        this.valueExpression = functor;
        this.assignTo = assignTo;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setValueExpression(this.createImplementor(element));
        this.setAssignTo(element.attributeValue("assignTo", this.getAssignTo()));
    }

    protected IFunctor createImplementor(IElement element) throws ConfigurationException {
        IElement implementorElement = element.element("value");
        if (implementorElement != null) {
            try {
                return ElementTools.createFunctor(null, implementorElement, null, this.getContext());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException(e);
            }
        }
        return null;
    }

    public void dispose() throws FunctorInvocationException {
        this.disposeChild(this.valueExpression);
    }

    public String getAssignTo() {
        return this.assignTo;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        if (this.assignTo != null) {
            sb.append(this.assignTo);
            sb.append(" = ");
        }
        sb.append(this.getChildLabel(this.valueExpression));
        return sb.toString();
    }

    public IFunctor getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public T perform(IFunctorCall call) throws FunctorInvocationException {
        T result = null;
        if (this.valueExpression != null) {
            try {
                result = this.valueExpression.perform(call);
            }
            catch (MacroControlFlow e) {
                return (T)this.handleControlFlow(e);
            }
        }
        if (!StringTools.isEmpty(this.getAssignTo())) {
            call.getArgs().put(this.getAssignTo(), result);
        }
        return result;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue("assignTo", this.getAssignTo());
        IElement implementorElement = element.newElement("value");
        this.serializeChildFunctor(this.getValueExpression(), implementorElement);
    }

    public void setAssignTo(String assignTo) {
        this.assignTo = assignTo;
    }

    public void setValueExpression(IFunctor functor) {
        this.valueExpression = functor;
        this.associateChild(functor);
    }
}

