/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.macro;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.macro.MacroControlFlow;
import de.intarsys.tools.macro.MacroFunctor;

public class MacroCondition
extends MacroFunctor {
    private IFunctor ifExpression;
    private IFunctor thenExpression;
    private IFunctor elseExpression;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement stepElement = element.element("if");
        this.ifExpression = this.createFunctor(stepElement);
        stepElement = element.element("then");
        this.thenExpression = this.createFunctor(stepElement);
        stepElement = element.element("else");
        this.elseExpression = this.createFunctor(stepElement);
    }

    public IFunctor getElseExpression() {
        return this.elseExpression;
    }

    public IFunctor getIfExpression() {
        return this.ifExpression;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("if (");
        if (this.ifExpression != null) {
            sb.append(this.getChildLabel(this.ifExpression));
        }
        sb.append(") ");
        sb.append("then\n");
        if (this.thenExpression != null) {
            sb.append(" { \n");
            sb.append(this.getChildLabel(this.thenExpression));
            sb.append("\n }");
        } else {
            sb.append(" { }");
        }
        if (this.elseExpression != null) {
            sb.append("\n else { \n");
            sb.append(this.getChildLabel(this.elseExpression));
            sb.append("\n }");
        }
        return sb.toString();
    }

    public IFunctor getThenExpression() {
        return this.thenExpression;
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorInvocationException {
        boolean conditionResult = true;
        if (this.getIfExpression() != null) {
            Object tempObj = this.getIfExpression().perform(call);
            try {
                conditionResult = ConverterRegistry.get().convert(tempObj, Boolean.class);
            }
            catch (ConversionException e) {
                throw new FunctorInvocationException(e);
            }
        }
        try {
            if (conditionResult) {
                if (this.getThenExpression() != null) {
                    return this.getThenExpression().perform(call);
                }
            } else if (this.getElseExpression() != null) {
                return this.getElseExpression().perform(call);
            }
        }
        catch (MacroControlFlow e) {
            return this.handleControlFlow(e);
        }
        return null;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        IElement temp;
        super.serialize(element);
        if (this.ifExpression != null) {
            temp = element.newElement("if");
            this.serializeChildFunctor(this.ifExpression, temp);
        }
        if (this.thenExpression != null) {
            temp = element.newElement("then");
            this.serializeChildFunctor(this.thenExpression, temp);
        }
        if (this.elseExpression != null) {
            temp = element.newElement("else");
            this.serializeChildFunctor(this.elseExpression, temp);
        }
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        super.setContext(context);
        this.setChildContext(this.getIfExpression(), context);
        this.setChildContext(this.getThenExpression(), context);
        this.setChildContext(this.getElseExpression(), context);
    }

    public void setElseExpression(IFunctor step) {
        this.elseExpression = step;
        this.associateChild(step);
    }

    public void setIfExpression(IFunctor step) {
        this.ifExpression = step;
        this.associateChild(step);
    }

    public void setThenExpression(IFunctor step) {
        this.thenExpression = step;
        this.associateChild(step);
    }
}

