/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.macro;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.macro.Break;
import de.intarsys.tools.macro.Continue;
import de.intarsys.tools.macro.MacroControlFlow;
import de.intarsys.tools.macro.MacroFunctor;

public class MacroLoop
extends MacroFunctor {
    private IFunctor initExpression;
    private IFunctor whileExpression;
    private IFunctor doExpression;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement stepElement = element.element("init");
        this.initExpression = this.createFunctor(stepElement);
        stepElement = element.element("while");
        this.whileExpression = this.createFunctor(stepElement);
        stepElement = element.element("do");
        this.doExpression = this.createFunctor(stepElement);
    }

    public IFunctor getDoExpression() {
        return this.doExpression;
    }

    public IFunctor getInitExpression() {
        return this.initExpression;
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("for (");
        sb.append(this.getChildLabel(this.initExpression));
        sb.append("; ");
        sb.append(this.getChildLabel(this.whileExpression));
        sb.append(") { \n");
        sb.append(this.getChildLabel(this.doExpression));
        sb.append("\n }");
        return sb.toString();
    }

    public IFunctor getWhileExpression() {
        return this.whileExpression;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Object perform(IFunctorCall call) throws FunctorInvocationException {
        if (this.getInitExpression() != null) {
            this.getInitExpression().perform(call);
        }
        conditionResult = true;
        if (this.getWhileExpression() == null) ** GOTO lbl31
        tempObj = this.getWhileExpression().perform(call);
        try {
            conditionResult = ConverterRegistry.get().convert(tempObj, Boolean.class);
            if (true) ** GOTO lbl31
        }
        catch (ConversionException e) {
            throw new FunctorInvocationException(e);
        }
        do {
            try {
                if (this.getDoExpression() != null) {
                    this.getDoExpression().perform(call);
                }
            }
            catch (Break e) {
                return null;
            }
            catch (Continue e) {
            }
            catch (MacroControlFlow e) {
                return this.handleControlFlow(e);
            }
            if (this.getWhileExpression() == null) continue;
            tempObj = this.getWhileExpression().perform(call);
            try {
                conditionResult = ConverterRegistry.get().convert(tempObj, Boolean.class);
            }
            catch (ConversionException e) {
                throw new FunctorInvocationException(e);
            }
lbl31:
            // 4 sources

        } while (conditionResult);
        return null;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        IElement temp;
        super.serialize(element);
        if (this.initExpression != null) {
            temp = element.newElement("init");
            this.serializeChildFunctor(this.initExpression, temp);
        }
        if (this.whileExpression != null) {
            temp = element.newElement("while");
            this.serializeChildFunctor(this.whileExpression, temp);
        }
        if (this.doExpression != null) {
            temp = element.newElement("do");
            this.serializeChildFunctor(this.doExpression, temp);
        }
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        super.setContext(context);
        this.setChildContext(this.getInitExpression(), context);
        this.setChildContext(this.getWhileExpression(), context);
        this.setChildContext(this.getDoExpression(), context);
    }

    public void setDoExpression(IFunctor step) {
        this.doExpression = step;
        this.associateChild(step);
    }

    public void setInitExpression(IFunctor step) {
        this.initExpression = step;
        this.associateChild(step);
    }

    public void setWhileExpression(IFunctor step) {
        this.whileExpression = step;
        this.associateChild(step);
    }
}

