/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.macro;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.macro.MacroControlFlow;
import de.intarsys.tools.macro.MacroFunctor;
import de.intarsys.tools.macro.Return;

public class MacroReturn
extends MacroFunctor {
    private IFunctor valueExpression;

    public MacroReturn() {
    }

    public MacroReturn(IFunctor expr) {
        this.setValueExpression(expr);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        IElement stepElement = element.element("value");
        this.valueExpression = this.createFunctor(stepElement);
    }

    @Override
    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        sb.append("return ");
        sb.append(this.getChildLabel(this.valueExpression));
        return sb.toString();
    }

    public IFunctor getValueExpression() {
        return this.valueExpression;
    }

    @Override
    public Object perform(IFunctorCall call) throws FunctorInvocationException {
        try {
            Object result = this.getValueExpression() != null ? this.getValueExpression().perform(call) : null;
            throw new Return((Object)result);
        }
        catch (MacroControlFlow e) {
            return this.handleControlFlow(e);
        }
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        if (this.valueExpression != null) {
            IElement temp = element.newElement("value");
            this.serializeChildFunctor(this.valueExpression, temp);
        }
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        super.setContext(context);
        this.setChildContext(this.getValueExpression(), context);
    }

    public void setValueExpression(IFunctor step) {
        this.valueExpression = step;
        this.associateChild(step);
    }
}

