/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.message;

import de.intarsys.tools.message.Message;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageBundle {
    private ClassLoader classLoader;
    private Locale locale;
    private String path;
    private ResourceBundle resourceBundle;

    protected static URL[] createURLs(String classpath) {
        if (classpath == null) {
            return new URL[0];
        }
        String[] names = classpath.split(";");
        URL[] urls = new URL[names.length];
        try {
            int i = 0;
            while (i < urls.length) {
                urls[i] = new File(names[i]).toURI().toURL();
                ++i;
            }
        }
        catch (MalformedURLException e) {
            return new URL[0];
        }
        return urls;
    }

    public MessageBundle() {
    }

    public MessageBundle(String path, ClassLoader classLoader) {
        this.path = path;
        this.classLoader = classLoader;
    }

    public MessageBundle(String path, String classpath) {
        this.path = path;
        this.classLoader = new URLClassLoader(MessageBundle.createURLs(classpath), Thread.currentThread().getContextClassLoader());
    }

    public String basicFormat(String pattern, Object ... objects) {
        return MessageFormat.format(pattern, objects);
    }

    protected Object basicGetObject(String key) {
        try {
            ResourceBundle myBundle = this.getResourceBundle();
            if (myBundle != null) {
                return myBundle.getObject(key);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String basicGetString(String key) {
        try {
            ResourceBundle myBundle = this.getResourceBundle();
            if (myBundle != null) {
                return myBundle.getString(key);
            }
            return null;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected ResourceBundle createResourceBundle() {
        if (this.getClassLoader() == null) {
            return ResourceBundle.getBundle(this.getPath(), this.getLocale());
        }
        return ResourceBundle.getBundle(this.getPath(), this.getLocale(), this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected String getFallbackString(String key, Object ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(key);
        sb.append("}");
        if (objects != null) {
            int i = 0;
            while (i < objects.length) {
                sb.append("[");
                sb.append(objects[i]);
                sb.append("]");
                ++i;
            }
        }
        return sb.toString();
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
        return this.locale;
    }

    public Message getMessage(String key) {
        return new Message(this, key);
    }

    public Object getObject(String key) {
        return this.basicGetObject(key);
    }

    public String getPath() {
        return this.path;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = this.createResourceBundle();
        }
        return this.resourceBundle;
    }

    public String getString(String key) {
        String result = this.basicGetString(key);
        if (result == null) {
            return this.getFallbackString(key, new Object[0]);
        }
        return result.replace("''", "'");
    }

    public String getString(String key, Object ... args) {
        String pattern = this.basicGetString(key);
        if (pattern == null) {
            return this.getFallbackString(key, args);
        }
        return MessageFormat.format(pattern, args);
    }

    public boolean lookupString(String key) {
        String result = this.basicGetString(key);
        return result != null;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setPath(String resourcesName) {
        this.path = resourcesName;
    }
}

