/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.monitor.AbstractMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.Trace;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMonitor
implements IMonitor,
IElementConfigurable {
    private static Level defaultLevel = Level.INFO;
    private String name;
    private Logger logger;
    private Level level = defaultLevel;
    private LinkedList traces = new LinkedList();
    private int collectAll = 0;
    private int logCycle = 100;
    private int traceCount = 0;
    private ThreadLocal<AbstractMonitorTrace> tracePerThread = new ThreadLocal<AbstractMonitorTrace>(){

        @Override
        protected AbstractMonitorTrace initialValue() {
            return AbstractMonitor.this.createMonitorTrace();
        }
    };

    public static Level getDefaultLevel() {
        return defaultLevel;
    }

    public static void setDefaultLevel(Level defaultLevel) {
        AbstractMonitor.defaultLevel = defaultLevel;
    }

    public AbstractMonitor() {
        this("");
    }

    public AbstractMonitor(String name) {
        this.name = name;
        this.logger = Logger.getLogger(name);
    }

    @Override
    public final ITrace attach() {
        AbstractMonitorTrace trace = (AbstractMonitorTrace)this.getCurrentTrace();
        trace.start();
        Trace.registerTrace(trace);
        return trace;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        this.setName(ElementTools.getPathString(element, "name", ""));
        this.setCollectAll(ElementTools.getPathInt(element, "collect.count", 0));
        String loggerString = ElementTools.getPathString(element, "logger", this.getName());
        if (loggerString != null) {
            Logger logger = Logger.getLogger(loggerString);
            this.setLogger(logger);
        }
        String defaultLevelString = defaultLevel.getName();
        String levelString = ElementTools.getPathString(element, "level", defaultLevelString);
        this.setLevel(Level.parse(levelString));
        int intValue = ElementTools.getPathInt(element, "logcycle", 100);
        this.setLogCycle(intValue);
    }

    protected abstract AbstractMonitorTrace createMonitorTrace();

    @Override
    public final void detach() {
        AbstractMonitorTrace trace = (AbstractMonitorTrace)this.getCurrentTrace();
        trace.stop();
    }

    protected LinkedList getBasicTraces() {
        return this.traces;
    }

    public int getCollectAll() {
        return this.collectAll;
    }

    @Override
    public ITrace getCurrentTrace() {
        return this.tracePerThread.get();
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLogCycle() {
        return this.logCycle;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized List getTraces() {
        ArrayList list = new ArrayList(this.traces);
        return list;
    }

    @Override
    public void reset() {
        this.traceLog();
        this.traces = new LinkedList();
        this.traceCount = 0;
    }

    public void setCollectAll(int count) {
        this.collectAll = count;
    }

    public void setLevel(Level traceLogLevel) {
        this.level = traceLogLevel;
    }

    public void setLogCycle(int pLogCycle) {
        this.logCycle = pLogCycle;
    }

    public void setLogger(Logger traceLog) {
        this.logger = traceLog;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public void start() {
        this.attach();
    }

    protected synchronized void started(ITrace trace) {
    }

    @Deprecated
    public void stop() {
        this.detach();
    }

    protected synchronized void stopped(ITrace trace) {
        Trace.unregisterTrace(trace);
        if (this.getCollectAll() > 0) {
            this.getBasicTraces().add(trace);
            this.tracePerThread.set(this.createMonitorTrace());
            if (this.getCollectAll() < this.getBasicTraces().size()) {
                this.getBasicTraces().removeFirst();
            }
        }
        ++this.traceCount;
        if (this.getLogCycle() != -1 && this.traceCount >= this.getLogCycle()) {
            this.reset();
        }
    }

    protected void traceLog() {
        if (this.getLogger() != null) {
            this.getLogger().logp(this.getLevel(), "", "", this.toString());
        }
    }
}

