/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.ISample;
import de.intarsys.tools.monitor.ITrace;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public abstract class AbstractMonitorTrace
implements ITrace {
    private final AbstractMonitor owner;
    private final Level level;
    private int nesting = 0;
    private Map tags;

    public AbstractMonitorTrace(AbstractMonitor owner) {
        this.owner = owner;
        this.level = owner.getLevel();
    }

    protected abstract ISample basicSample(String var1);

    protected void basicStart() {
        ++this.nesting;
        if (this.nesting == 1) {
            this.owner.started(this);
            if (this.tags != null && this.tags.size() > 0) {
                this.tags.clear();
            }
        } else {
            this.sample(Level.INFO, "start");
        }
    }

    protected void basicStop() {
        --this.nesting;
        if (this.nesting == 0) {
            this.owner.stopped(this);
            this.traceLog();
        } else {
            this.sample(Level.INFO, "stop");
        }
    }

    protected void basicTag(String key, Object tag) {
        if (this.tags == null) {
            this.tags = new HashMap();
        }
        this.tags.put(key, tag);
    }

    protected final AbstractMonitor getOwner() {
        return this.owner;
    }

    public Map getTags() {
        return this.tags;
    }

    @Override
    public final ISample sample(Level level, String description) {
        if (this.level.intValue() > level.intValue()) {
            return null;
        }
        return this.basicSample(description);
    }

    protected final void start() {
        this.basicStart();
    }

    protected final void stop() {
        this.basicStop();
    }

    @Override
    public final void tag(String key, Object tag) {
        this.basicTag(key, tag);
    }

    protected void traceLog() {
    }
}

