/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.AbstractMonitor;
import de.intarsys.tools.monitor.CompositeMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.MonitorFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.HashMap;
import java.util.Map;

public class CompositeMonitor
extends AbstractMonitor {
    private IMonitor[] children = new IMonitor[0];

    public CompositeMonitor() {
    }

    public CompositeMonitor(String name) {
        super(name);
    }

    public void addMonitor(IMonitor monitor) {
        int count = 0;
        count = this.children == null ? 1 : this.children.length + 1;
        IMonitor[] newMonitors = new IMonitor[count];
        System.arraycopy(this.children, 0, newMonitors, 0, count - 1);
        newMonitors[count - 1] = monitor;
        this.children = newMonitors;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        try {
            this.children = MonitorFactory.createMonitors(element, null);
        }
        catch (ObjectCreationException e) {
            throw new ConfigurationException(e);
        }
    }

    @Override
    protected CompositeMonitorTrace createMonitorTrace() {
        ITrace[] traces = new ITrace[this.getChildren().length];
        int i = 0;
        while (i < this.children.length) {
            traces[i] = this.children[i].getCurrentTrace();
            ++i;
        }
        CompositeMonitorTrace trace = new CompositeMonitorTrace(this, traces);
        return trace;
    }

    public IMonitor[] getChildren() {
        return this.children;
    }

    @Override
    public Map getData() {
        HashMap result = new HashMap();
        int i = 0;
        while (i < this.children.length) {
            Map childData = this.children[i].getData();
            for (Map.Entry entry : childData.entrySet()) {
                result.put(this.children[i].getName() + "." + entry.getKey(), entry.getValue());
            }
            ++i;
        }
        return result;
    }

    @Override
    public Map getFormattedData() {
        HashMap result = new HashMap();
        int i = 0;
        while (i < this.children.length) {
            Map childData = this.children[i].getFormattedData();
            for (Map.Entry entry : childData.entrySet()) {
                result.put(this.children[i].getName() + "." + entry.getKey(), entry.getValue());
            }
            ++i;
        }
        return result;
    }

    @Override
    public void reset() {
        super.reset();
        int i = 0;
        while (i < this.children.length) {
            this.children[i].reset();
            ++i;
        }
    }

    public String toString() {
        return "Composite Monitor " + this.getName();
    }
}

