/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.MemberMonitorTrace;
import de.intarsys.tools.monitor.Monitor;
import de.intarsys.tools.monitor.MonitorTrace;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class MemberMonitor
extends Monitor {
    private Class clazz;
    private Method method;
    private Field field;

    public MemberMonitor() {
    }

    public MemberMonitor(String name) {
        super(name);
    }

    public MemberMonitor(String name, Class clazz, Field field) {
        super(name);
        this.clazz = clazz;
        this.field = field;
    }

    public MemberMonitor(String name, Class clazz, Method method) {
        super(name);
        this.clazz = clazz;
        this.method = method;
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        String fieldName;
        super.configure(element);
        String className = ElementTools.getPathString(element, "monitoredclass", null);
        if (className == null) {
            throw new ConfigurationException("<monitoredclass> may not be null");
        }
        try {
            this.clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.valueOf(className) + " not found");
        }
        catch (SecurityException e) {
            throw new ConfigurationException(String.valueOf(className) + " not permitted");
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException(String.valueOf(className) + " not instantiable");
        }
        String methodName = ElementTools.getPathString(element, "monitoredmethod", null);
        if (methodName != null) {
            try {
                this.method = this.getClazz().getMethod(methodName, new Class[0]);
            }
            catch (SecurityException e) {
                throw new ConfigurationException(String.valueOf(methodName) + " not permitted");
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.valueOf(methodName) + " not instantiable");
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(String.valueOf(methodName) + " not found");
            }
        }
        if ((fieldName = ElementTools.getPathString(element, "monitoredfield", null)) != null) {
            try {
                this.field = this.getClazz().getField(fieldName);
            }
            catch (SecurityException e) {
                throw new ConfigurationException(String.valueOf(fieldName) + " not permitted");
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.valueOf(fieldName) + " not instantiable");
            }
            catch (NoSuchFieldException e) {
                throw new ConfigurationException(String.valueOf(fieldName) + " not found");
            }
        }
        if (this.field == null && this.method == null) {
            throw new ConfigurationException("field or method must be set");
        }
    }

    @Override
    protected MemberMonitorTrace createMonitorTrace() {
        return new MemberMonitorTrace(this);
    }

    @Override
    protected void doCalculation(MonitorTrace trace) {
        if (trace.getStart() < this.statistic.min) {
            this.statistic.min = trace.getStart();
        }
        if (trace.getStop() < this.statistic.min) {
            this.statistic.min = trace.getStop();
        }
        if (trace.getStart() > this.statistic.max) {
            this.statistic.max = trace.getStart();
        }
        if (trace.getStop() > this.statistic.max) {
            this.statistic.max = trace.getStop();
        }
        this.statistic.total = this.last - this.first;
        this.statistic.avg = (this.statistic.avg * this.statistic.count + trace.getStop()) / (this.statistic.count + 1L);
        ++this.statistic.count;
    }

    protected Class getClazz() {
        return this.clazz;
    }

    protected Field getField() {
        return this.field;
    }

    protected Method getMethod() {
        return this.method;
    }
}

