/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.MonitorRegistry;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.ArrayList;
import java.util.Iterator;

public class MonitorFactory {
    public static IMonitor[] createMonitors(IElement element, Object context) throws ObjectCreationException {
        ArrayList<IMonitor> monitors = new ArrayList<IMonitor>();
        IElement eMonitors = element.element("monitors");
        if (eMonitors != null) {
            Iterator<IElement> it = element.elementIterator("monitor");
            while (it.hasNext()) {
                IElement eMonitor = it.next();
                IMonitor monitor = ElementTools.createObject(eMonitor, IMonitor.class, context);
                monitors.add(monitor);
                MonitorRegistry.get().registerMonitor(monitor);
            }
        }
        return monitors.toArray(new IMonitor[monitors.size()]);
    }

    private MonitorFactory() {
    }
}

