/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.monitor.ISample;
import de.intarsys.tools.monitor.ITrace;
import java.util.List;
import java.util.logging.Level;

public class MultiTrace
implements ITrace {
    private Object trace = null;

    public void registerTrace(ITrace pTrace) {
        if (this.trace == null) {
            this.trace = pTrace;
        } else if (this.trace instanceof List) {
            ((List)this.trace).add(pTrace);
        } else {
            this.trace = ListTools.with((ITrace)this.trace, pTrace);
        }
    }

    @Override
    public ISample sample(Level level, String description) {
        if (this.trace == null) {
            return null;
        }
        if (this.trace instanceof List) {
            for (ITrace childTrace : (List)this.trace) {
                childTrace.sample(level, description);
            }
            return null;
        }
        return ((ITrace)this.trace).sample(level, description);
    }

    @Override
    public void tag(String key, Object tag) {
        if (this.trace == null) {
            return;
        }
        if (this.trace instanceof List) {
            for (ITrace childTrace : (List)this.trace) {
                childTrace.tag(key, tag);
            }
        } else {
            ((ITrace)this.trace).tag(key, tag);
        }
    }

    public void unregisterTrace(ITrace pTrace) {
        if (this.trace == null) {
            return;
        }
        if (this.trace instanceof List) {
            ((List)this.trace).remove(pTrace);
            if (((List)this.trace).size() == 0) {
                this.trace = null;
            }
        } else if (this.trace == pTrace) {
            this.trace = null;
        }
    }
}

