/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.net;

import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.net.CommonHostnameVerifier;
import de.intarsys.tools.net.DenyAllHostnameVerifier;
import de.intarsys.tools.reflect.ObjectTools;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

public class StrictHostnameVerifier
extends CommonHostnameVerifier {
    private static final Logger Log = LogTools.getLogger(StrictHostnameVerifier.class);
    private static HostnameVerifier implementor;

    static {
        try {
            implementor = ObjectTools.createObject("org.apache.http.conn.ssl.StrictHostnameVerifier", HostnameVerifier.class, null);
        }
        catch (Throwable e1) {
            Log.log(Level.WARNING, "Apache HTTP client hostname verifier not found");
            try {
                implementor = ObjectTools.createObject("de.intarsys.tools.net.SunBasedHostnameVerifier", HostnameVerifier.class, null);
            }
            catch (Throwable e2) {
                Log.log(Level.WARNING, "SUN hostname verifier not found");
                Log.log(Level.WARNING, "We will deny all hostnames on SSL connections");
                implementor = new DenyAllHostnameVerifier();
            }
        }
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return implementor.verify(hostname, session);
    }
}

