/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.net;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.kerberos.KerberosPrincipal;
import sun.security.util.HostnameChecker;

class SunBasedHostnameVerifier
implements HostnameVerifier {
    SunBasedHostnameVerifier() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean verify(String hostname, SSLSession session) {
        HostnameChecker checker = HostnameChecker.getInstance((byte)1);
        Certificate[] peerCertificates = session.getPeerCertificates();
        if (peerCertificates.length <= 0 || !(peerCertificates[0] instanceof X509Certificate)) return false;
        X509Certificate peerCertificate = (X509Certificate)peerCertificates[0];
        try {
            checker.match(hostname, peerCertificate);
            return true;
        }
        catch (CertificateException certificateException) {
            try {
                return false;
            }
            catch (SSLPeerUnverifiedException ex) {
                try {
                    Principal peerPrincipal = session.getPeerPrincipal();
                    if (!(peerPrincipal instanceof KerberosPrincipal)) return false;
                    return HostnameChecker.match((String)hostname, (Principal)peerPrincipal);
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
        }
        return false;
    }
}

