/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.net;

import de.intarsys.tools.net.TCPListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class TCPConnection {
    private TCPListener listener;
    private Socket socket;
    private InputStream input;
    private OutputStream output;

    public TCPConnection(TCPListener newListener, Socket newSocket) {
        this.setListener(newListener);
        this.setSocket(newSocket);
    }

    public InputStream getInput() {
        return this.input;
    }

    public TCPListener getListener() {
        return this.listener;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public String getRemoteAddr() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public String getRemoteHost() {
        return this.socket.getInetAddress().getHostName();
    }

    public String getServerName() {
        return this.getSocket().getLocalAddress().getHostName();
    }

    public int getServerPort() {
        return this.getListener().getPort();
    }

    public Socket getSocket() {
        return this.socket;
    }

    private void setInput(InputStream newInput) {
        this.input = newInput;
    }

    private void setListener(TCPListener newListener) {
        this.listener = newListener;
    }

    private void setOutput(OutputStream newOutput) {
        this.output = newOutput;
    }

    private void setSocket(Socket newSocket) {
        this.socket = newSocket;
    }

    public void start() throws SocketException, IOException {
        this.socket.setSoTimeout(120000);
        this.setInput(this.socket.getInputStream());
        this.setOutput(this.socket.getOutputStream());
    }

    public void stop() {
        try {
            this.getOutput().close();
            this.output = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.getInput().close();
            this.input = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.getSocket().close();
            this.socket = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

