/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.net;

import de.intarsys.tools.net.TCPConnection;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPListener
implements Runnable {
    private String name = "a TCP Listener";
    private int port;
    private ServerSocket serverSocket;
    private Thread listenerThread;
    private ExecutorService executor;
    private static final Logger Log = Logger.getLogger("de.intarsys.tools.net");

    public TCPListener(int port) {
        this.setPort(port);
    }

    public TCPConnection createConnection(Socket socket) {
        return new TCPConnection(this, socket);
    }

    protected ExecutorService createExecutor() {
        return Executors.newFixedThreadPool(this.getFixedThreadCount(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "TCPListener executor");
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        Log.log(Level.WARNING, "uncaught exception in " + t, e);
                    }
                });
                return null;
            }
        });
    }

    protected Thread createListenerThread() {
        Thread t = new Thread((Runnable)this, this.getName());
        t.setDaemon(true);
        return t;
    }

    protected synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = this.createExecutor();
        }
        return this.executor;
    }

    protected int getFixedThreadCount() {
        return 3;
    }

    public Thread getListenerThread() {
        return this.listenerThread;
    }

    public String getName() {
        return String.valueOf(this.name) + " on port " + Integer.toString(this.port);
    }

    public int getPort() {
        return this.port;
    }

    protected ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void handleConnection(final TCPConnection c) {
        this.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                TCPListener.this.handleConnectionThreaded(c);
            }
        });
    }

    public void handleConnectionThreaded(TCPConnection c) {
        c.stop();
    }

    public void handleException(Exception e) {
        Log.log(Level.SEVERE, "Socket Error, terminating Listener (" + e.getMessage() + ")");
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            block13: {
                Socket s;
                block12: {
                    s = null;
                    if (!true) break block12;
                    if (Thread.interrupted()) return;
                    if (this.getListenerThread() == null) break block13;
                }
                do {
                    try {
                        s = this.getServerSocket().accept();
                        TCPConnection c = this.createConnection(s);
                        c.start();
                        try {
                            this.handleConnection(c);
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        TCPListener tCPListener = this;
                        synchronized (tCPListener) {
                            if (this.getListenerThread() == null) return;
                            this.handleException(e);
                            return;
                        }
                    }
                    if (Thread.interrupted()) return;
                } while (this.getListenerThread() != null);
            }
            return;
        }
        finally {
            this.stop();
        }
    }

    protected void setListenerThread(Thread newListenerThread) {
        this.listenerThread = newListenerThread;
    }

    public void setPort(int newPort) {
        this.port = newPort;
    }

    protected void setServerSocket(ServerSocket newServerSocket) {
        this.serverSocket = newServerSocket;
    }

    public void start() throws IOException {
        this.setServerSocket(new ServerSocket(this.getPort()));
        this.setPort(this.getServerSocket().getLocalPort());
        this.setListenerThread(this.createListenerThread());
        this.getListenerThread().start();
    }

    public synchronized void stop() {
        Thread l = this.getListenerThread();
        this.setListenerThread(null);
        if (l != null) {
            l.interrupt();
        }
        try {
            if (this.getServerSocket() != null) {
                this.getServerSocket().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }
}

