/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.notice;

import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.notice.Notice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class NoticeTools {
    public static void clearNonSticky(INoticesSupport ns) {
        ArrayList<Notice> notices = new ArrayList<Notice>(ns.getNotices());
        for (Notice notice : notices) {
            if (notice.isSticky()) continue;
            ns.removeNotice(notice);
        }
    }

    public static boolean hasError(INoticesSupport ns) {
        for (Notice notice : ns.getNotices()) {
            if (!notice.isError()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInfo(INoticesSupport ns) {
        for (Notice notice : ns.getNotices()) {
            if (!notice.isInfo()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNotices(INoticesSupport ns) {
        return ns.getNotices().size() > 0;
    }

    public static boolean hasWarning(INoticesSupport ns) {
        for (Notice notice : ns.getNotices()) {
            if (!notice.isWarning()) continue;
            return true;
        }
        return false;
    }

    public static List<Notice> sortBySeverity(INoticesSupport ns) {
        ArrayList<Notice> notices = new ArrayList<Notice>(ns.getNotices());
        Collections.sort(notices, new Comparator<Notice>(){

            @Override
            public int compare(Notice o1, Notice o2) {
                if (o1.getSeverity() < o2.getSeverity()) {
                    return 1;
                }
                if (o1.getSeverity() > o2.getSeverity()) {
                    return -1;
                }
                return 0;
            }
        });
        return notices;
    }
}

