/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IScopedPlatformPreferences;
import de.intarsys.tools.preferences.PreferencesChangeEvent;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IBasicAccessSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

public class PreferencesAdapter
implements IPreferences,
INotificationSupport,
PreferenceChangeListener,
IBasicAccessSupport {
    private final Map<String, PreferencesAdapter> children = new HashMap<String, PreferencesAdapter>();
    private final Preferences jPrefs;
    private final PreferencesAdapter parent;
    private EventDispatcher dispatcher;
    private final Object lock = new Object();
    private final PreferencesAdapter root;
    public static final String NODE_METADATA = "__metadata";
    public static final String MODIFIER_NULL = "null";

    public PreferencesAdapter(PreferencesAdapter parent, Preferences jPrefs) {
        this.parent = parent;
        this.jPrefs = jPrefs;
        this.root = parent != null ? parent.root : this;
    }

    @Override
    public String absolutePath() {
        return this.jPrefs.absolutePath();
    }

    @Override
    public synchronized void addNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            this.dispatcher = new EventDispatcher(this);
            this.jPrefs.addPreferenceChangeListener(this);
        }
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public Object basicGetValue(String name) throws FieldException {
        try {
            if (this.nodeExists(name)) {
                return this.node(name);
            }
        }
        catch (BackingStoreException e) {
            throw new FieldAccessException(this.getClass(), name);
        }
        return this.get(name);
    }

    @Override
    public Object basicSetValue(String name, Object value) throws FieldException {
        String oldValue = this.get(name);
        if (value == null) {
            this.remove(name);
        } else {
            String stringValue;
            try {
                stringValue = ConverterRegistry.get().convert(value, String.class);
            }
            catch (ConversionException e) {
                stringValue = String.valueOf(value);
            }
            this.put(name, stringValue);
        }
        return oldValue;
    }

    @Override
    public IPreferences[] children() {
        ArrayList<IPreferences> children = new ArrayList<IPreferences>();
        String[] names = this.childrenNames();
        int i = 0;
        while (i < names.length) {
            children.add(this.node(names[i]));
            ++i;
        }
        return children.toArray(new IPreferences[children.size()]);
    }

    @Override
    public String[] childrenNames() {
        try {
            String[] basicNames = this.jPrefs.childrenNames();
            ArrayList<String> result = new ArrayList<String>();
            String[] stringArray = basicNames;
            int n = basicNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!NODE_METADATA.equals(name)) {
                    result.add(name);
                }
                ++n2;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (BackingStoreException e) {
            return new String[0];
        }
    }

    @Override
    public void clear() throws BackingStoreException {
        this.jPrefs.clear();
    }

    protected PreferencesAdapter createPreferencesNode(String pathName) {
        return new PreferencesAdapter(this, this.jPrefs.node(pathName));
    }

    @Override
    public void flush() {
        try {
            this.jPrefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String get(String name) {
        if (this.hasModifier(name, MODIFIER_NULL)) {
            return null;
        }
        return this.jPrefs.get(name, null);
    }

    @Override
    public String get(String key, String def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.get(key, def);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    @Override
    public boolean getBoolean(String key, boolean def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getBoolean(key, def);
    }

    @Override
    public byte[] getByteArray(String key, byte[] def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getByteArray(key, def);
    }

    @Override
    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    @Override
    public double getDouble(String key, double def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getDouble(key, def);
    }

    @Override
    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    @Override
    public float getFloat(String key, float def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getFloat(key, def);
    }

    @Override
    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    @Override
    public int getInt(String key, int def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getInt(key, def);
    }

    @Override
    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    @Override
    public long getLong(String key, long def) {
        if (this.hasModifier(key, MODIFIER_NULL)) {
            return def;
        }
        return this.jPrefs.getLong(key, def);
    }

    protected Preferences getMetadata() {
        return this.jPrefs.node(NODE_METADATA);
    }

    @Override
    public String getModifierString(String key) {
        return this.getMetadata().get(key, null);
    }

    @Override
    public boolean hasModifier(String key, String modifier) {
        String modifierString = this.getModifierString(key);
        if (modifierString == null) {
            return false;
        }
        return modifierString.indexOf(modifier) >= 0;
    }

    @Override
    public String[] keys() {
        try {
            return this.jPrefs.keys();
        }
        catch (BackingStoreException e) {
            return new String[0];
        }
    }

    @Override
    public String name() {
        return this.jPrefs.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IPreferences node(String pathName) {
        Object object = this.lock;
        synchronized (object) {
            if (pathName.equals("")) {
                return this;
            }
            if (pathName.equals("/")) {
                return this.root;
            }
            if (!pathName.startsWith("/")) {
                return this.node(new StringTokenizer(pathName, "/", true));
            }
        }
        return this.root.node(new StringTokenizer(pathName.substring(1), "/", true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IPreferences node(StringTokenizer path) {
        String token = path.nextToken();
        if (token.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        if (this.hasModifier(token, MODIFIER_NULL)) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            PreferencesAdapter child = this.children.get(token);
            if (child == null) {
                child = this.createPreferencesNode(token);
                this.children.put(token, child);
            }
            if (!path.hasMoreTokens()) {
                return child;
            }
            path.nextToken();
            if (!path.hasMoreTokens()) {
                throw new IllegalArgumentException("Path ends with slash");
            }
            return child.node(path);
        }
    }

    @Override
    public boolean nodeExists(String pathName) throws BackingStoreException {
        return this.jPrefs.nodeExists(pathName);
    }

    @Override
    public IPreferences parent() {
        return this.parent;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        this.triggerChange(evt);
    }

    @Override
    public Map<String, String> properties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        String[] keys = this.keys();
        int i = 0;
        while (i < keys.length) {
            properties.put(keys[i], this.get(keys[i]));
            ++i;
        }
        return properties;
    }

    @Override
    public void put(String name, boolean value) {
        this.jPrefs.putBoolean(name, value);
    }

    @Override
    public void put(String name, byte[] value) {
        if (value == null) {
            this.jPrefs.remove(name);
        } else {
            this.jPrefs.putByteArray(name, value);
        }
    }

    @Override
    public void put(String name, double value) {
        this.jPrefs.putDouble(name, value);
    }

    @Override
    public void put(String name, float value) {
        this.jPrefs.putFloat(name, value);
    }

    @Override
    public void put(String name, int value) {
        this.jPrefs.putInt(name, value);
    }

    @Override
    public void put(String name, long value) {
        this.jPrefs.putLong(name, value);
    }

    @Override
    public void put(String name, String value) {
        if (value == null) {
            this.jPrefs.remove(name);
        } else {
            this.jPrefs.put(name, value);
        }
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.jPrefs.putBoolean(key, value);
    }

    @Override
    public void putByteArray(String name, byte[] value) {
        if (value == null) {
            this.jPrefs.remove(name);
        } else {
            this.jPrefs.putByteArray(name, value);
        }
    }

    @Override
    public void putDouble(String key, double value) {
        this.jPrefs.putDouble(key, value);
    }

    @Override
    public void putFloat(String key, float value) {
        this.jPrefs.putFloat(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        this.jPrefs.putInt(key, value);
    }

    @Override
    public void putLong(String key, long value) {
        this.jPrefs.putLong(key, value);
    }

    @Override
    public void remove(String name) {
        this.jPrefs.remove(name);
        this.removeModifiers(name);
    }

    public void removeModifiers(String key) {
        this.getMetadata().remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode() throws BackingStoreException {
        if (this.parent == null) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        Object object = this.parent.lock;
        synchronized (object) {
            this.jPrefs.removeNode();
            this.parent.children.remove(this.jPrefs.name());
        }
    }

    @Override
    public synchronized void removeNotificationListener(EventType type, INotificationListener listener) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.removeNotificationListener(type, listener);
        if (this.dispatcher.isEmpty()) {
            this.jPrefs.removePreferenceChangeListener(this);
        }
    }

    @Override
    public IPreferences restrict(String scopeName) {
        if (this.jPrefs instanceof IScopedPlatformPreferences) {
            return new PreferencesAdapter(null, ((IScopedPlatformPreferences)((Object)this.jPrefs)).restrict(scopeName));
        }
        return this;
    }

    @Override
    public void setModifierString(String key, String modifiers) {
        if (modifiers == null) {
            this.getMetadata().remove(key);
        } else {
            this.getMetadata().put(key, modifiers);
        }
    }

    @Override
    public void sync() throws BackingStoreException {
        this.jPrefs.sync();
    }

    protected void triggerChange(PreferenceChangeEvent jEvent) {
        PreferencesChangeEvent event = new PreferencesChangeEvent(this);
        event.setKey(jEvent.getKey());
        event.setNewValue(jEvent.getNewValue());
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        if (this.dispatcher == null) {
            return;
        }
        this.dispatcher.triggerEvent(event);
    }
}

