/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.preferences.IPreferences;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;

public class PreferencesArgs
implements IArgs {
    private static final String UNDEFINED = new String();
    private final IPreferences preferences;

    public PreferencesArgs(IPreferences preferences) {
        this.preferences = preferences;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        return new ConversionIterator<String, IArgs.IBinding>(this.names().iterator()){

            @Override
            protected IArgs.IBinding createTargetObject(String name) {
                return new Binding(name);
            }
        };
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public IArgs copy() {
        return new PreferencesArgs(this.preferences);
    }

    @Override
    public IArgs.IBinding declare(String name) {
        return new Binding(name);
    }

    @Override
    public Object get(int index) {
        return this.get(String.valueOf(index));
    }

    @Override
    public Object get(int index, Object defaultValue) {
        return defaultValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object get(String name) {
        IPreferences childNode;
        block3: {
            try {
                if (!this.preferences.nodeExists(name)) return this.preferences.get(name, null);
                childNode = this.preferences.node(name);
                if (childNode != null) break block3;
                return null;
            }
            catch (BackingStoreException e) {
                return null;
            }
        }
        return new PreferencesArgs(childNode);
    }

    @Override
    public Object get(String name, Object defaultValue) {
        try {
            if (this.preferences.nodeExists(name)) {
                IPreferences childNode = this.preferences.node(name);
                return new PreferencesArgs(childNode);
            }
            String result = this.preferences.get(name, null);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        catch (BackingStoreException e) {
            return null;
        }
    }

    @Override
    public boolean isDefined(int index) {
        return this.isDefined(String.valueOf(index));
    }

    @Override
    public boolean isDefined(String name) {
        return this.preferences.get(name, UNDEFINED) != UNDEFINED;
    }

    public boolean isIndexed() {
        return false;
    }

    public boolean isNamed() {
        return true;
    }

    public Set names() {
        try {
            ArrayList<String> children = new ArrayList<String>(Arrays.asList(this.preferences.childrenNames()));
            List<String> keys = Arrays.asList(this.preferences.keys());
            children.addAll(keys);
            return new HashSet<String>(children);
        }
        catch (BackingStoreException e) {
            return new HashSet();
        }
    }

    @Override
    public IArgs.IBinding put(int index, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public IArgs.IBinding put(String name, Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public int size() {
        try {
            return this.preferences.childrenNames().length + this.preferences.keys().length;
        }
        catch (BackingStoreException e) {
            return 0;
        }
    }

    public String toString() {
        return ArgTools.toString(this, "[p]");
    }

    @Override
    public void undefine(int index) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    @Override
    public void undefine(String name) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("can not write to PreferencesArgs");
    }

    class Binding
    implements IArgs.IBinding {
        private String name;

        public Binding(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object getValue() {
            return PreferencesArgs.this.get(this.name);
        }

        @Override
        public boolean isDefined() {
            return PreferencesArgs.this.isDefined(this.name);
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public void setValue(Object value) {
            PreferencesArgs.this.put(this.name, value);
        }
    }
}

