/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.preferences;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.crypto.CryptoEnvironment;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.enumeration.EnumItem;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgumentDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.PreferenceValue;
import de.intarsys.tools.string.CharacterTools;
import de.intarsys.tools.string.Converter;
import de.intarsys.tools.string.ConverterException;
import de.intarsys.tools.string.StringTools;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public class PreferencesTools {
    public static final String ELEMENT_SEPARATOR = ";";
    public static final String KEY_VALUE_SEPARATOR = "=";
    private static final Logger Log = LogTools.getLogger(PreferencesTools.class);

    protected static Object convertValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return value;
        }
        try {
            return ConverterRegistry.get().convert(value, PreferenceValue.class);
        }
        catch (ConversionException e) {
            return StringTools.safeString(value);
        }
    }

    public static String fitKey(String name) {
        int length = name.length();
        if (length <= 80) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[length];
        name.getChars(0, length, chars, 0);
        boolean start = true;
        int i = 0;
        while (i < length) {
            char c = chars[i];
            if (c == '.' || c == '/' || c == '\\' || c == '_') {
                start = true;
            } else if (Character.isUpperCase(c) || c == '.') {
                start = true;
                sb.append(c);
            } else if (CharacterTools.isVowel(c)) {
                if (start) {
                    start = false;
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        name = sb.toString();
        length = name.length();
        if (length <= 80) {
            return name;
        }
        return name.substring(length - 80, length);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name) {
        if (preferences == null) {
            return meta.getDefault();
        }
        String optionValue = preferences.get(name);
        return meta.getItemOrDefault(optionValue);
    }

    public static <T extends EnumItem> T getEnumItem(IPreferences preferences, EnumMeta<T> meta, String name, String defaultValue) {
        if (preferences == null) {
            return meta.getItemOrDefault(defaultValue);
        }
        String optionValue = preferences.get(name, defaultValue);
        return meta.getItem(optionValue);
    }

    public static String getLarge(IPreferences preferences, String name, String defaultValue) {
        String subKey;
        String subValue;
        if (preferences == null) {
            return null;
        }
        IPreferences childNode = preferences.node(name);
        int i = 0;
        if ((subValue = childNode.get(subKey = "part" + i++, null)) == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        while (subValue != null && subValue.length() == 8192) {
            sb.append(subValue);
            subKey = "part" + i++;
            subValue = childNode.get(subKey, null);
        }
        if (subValue != null) {
            sb.append(subValue);
        }
        return sb.toString();
    }

    public static String getSecret(IPreferences preferences, String name, String defaultValue) {
        if (CryptoEnvironment.get() == null) {
            Log.log(Level.WARNING, "CryptoEnvironment not available, can't read preference '" + name + "'");
            return defaultValue;
        }
        try {
            String tempValue = preferences.get(name);
            if (StringTools.isEmpty(tempValue)) {
                return defaultValue;
            }
            return CryptoEnvironment.get().decryptStringEncoded(tempValue);
        }
        catch (IOException e) {
            Log.log(Level.WARNING, "CryptoEnvironment can't decrypt preference '" + name + "'");
            return defaultValue;
        }
    }

    public static void importPreferences(IPreferences root, IPreferences source) throws BackingStoreException {
        String[] childrenNames = source.childrenNames();
        int i = 0;
        while (i < childrenNames.length) {
            String childName = childrenNames[i];
            IPreferences rootChild = root.node(childName);
            IPreferences sourceChild = source.node(childName);
            PreferencesTools.importPreferences(rootChild, sourceChild);
            ++i;
        }
        String[] keys = source.keys();
        int i2 = 0;
        while (i2 < keys.length) {
            String key = keys[i2];
            root.put(key, source.get(key));
            ++i2;
        }
    }

    public static void mergeArgs(IPreferences source, IArgs args) {
        try {
            String[] childrenNames = source.childrenNames();
            int i = 0;
            while (i < childrenNames.length) {
                String childName = childrenNames[i];
                IPreferences sourceChild = source.node(childName);
                if (!args.isDefined(childName)) {
                    if (sourceChild == null) {
                        args.put(childName, null);
                    } else {
                        Args tempArgs = Args.create();
                        args.put(childName, (Object)tempArgs);
                        PreferencesTools.mergeArgs(sourceChild, tempArgs);
                    }
                }
                ++i;
            }
            String[] keys = source.keys();
            int i2 = 0;
            while (i2 < keys.length) {
                String key = keys[i2];
                if (!args.isDefined(key)) {
                    args.put(key, (Object)source.get(key));
                }
                ++i2;
            }
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    protected static void putArgArgs(IPreferences preferences, String name, IArgs pValue, IArgumentDeclaration argDecl, boolean secret) {
        IPreferences childNode = preferences.node(name);
        IDeclarationBlock argDeclBlock = null;
        if (argDecl instanceof IDeclarationBlock) {
            argDeclBlock = (IDeclarationBlock)((Object)argDecl);
        } else if (argDecl instanceof IDeclarationSupport) {
            argDeclBlock = ((IDeclarationSupport)((Object)argDecl)).getDeclarationBlock();
        }
        IDeclarationElement[] childDeclarations = null;
        if (argDeclBlock != null) {
            childDeclarations = argDeclBlock.getDeclarationElements();
        }
        if (childDeclarations != null) {
            PreferencesTools.putArgsDeclared(childNode, pValue, childDeclarations, secret);
        } else {
            PreferencesTools.putArgsAll(childNode, pValue, secret);
        }
    }

    protected static void putArgNull(IPreferences preferences, String name) {
    }

    public static void putArgs(IPreferences preferences, IArgs args, IDeclarationBlock block) {
        PreferencesTools.putArgsDeclared(preferences, args, block.getDeclarationElements(), false);
    }

    public static void putArgsAll(IPreferences preferences, IArgs args, boolean secret) {
        Set<String> names = args.names();
        if (names.isEmpty()) {
            int i = 0;
            while (i < args.size()) {
                Object value = args.get(i);
                PreferencesTools.putArgValue(preferences, String.valueOf(i), value, null, secret);
                ++i;
            }
        } else {
            for (String argName : names) {
                if (!args.isDefined(argName)) continue;
                Object value = args.get(argName);
                PreferencesTools.putArgValue(preferences, argName, value, null, secret);
            }
        }
    }

    public static void putArgsDeclared(IPreferences preferences, IArgs args, IDeclarationElement[] declarations, boolean secret) {
        int i = 0;
        while (i < declarations.length) {
            IDeclarationElement decl = declarations[i];
            if (decl instanceof IArgumentDeclaration) {
                IArgumentDeclaration argDecl = (IArgumentDeclaration)decl;
                boolean localSecret = secret || argDecl.hasModifier("secret");
                String argName = argDecl.getName();
                if (args.isDefined(argName)) {
                    Object argValue = args.get(argName);
                    PreferencesTools.putArgValue(preferences, argName, argValue, argDecl, localSecret);
                }
            }
            ++i;
        }
    }

    protected static void putArgString(IPreferences preferences, String name, Object pValue, boolean secret) {
        if (secret) {
            try {
                pValue = CryptoEnvironment.get().encryptStringEncoded(pValue.toString());
            }
            catch (IOException e) {
                pValue = "";
            }
        }
        preferences.put(name, StringTools.safeString(pValue));
    }

    public static void putArgValue(IPreferences preferences, String name, Object pValue, IArgumentDeclaration argDecl, boolean secret) {
        boolean modTransient;
        boolean bl = modTransient = argDecl != null && argDecl.hasModifier("transient");
        if (modTransient) {
            return;
        }
        if (pValue instanceof Secret) {
            secret = true;
            pValue = ((Secret)pValue).getValue();
        }
        if (secret) {
            return;
        }
        if ((pValue = PreferencesTools.convertValue(pValue)) == null) {
            PreferencesTools.putArgNull(preferences, name);
        } else if (pValue instanceof IArgs) {
            PreferencesTools.putArgArgs(preferences, name, (IArgs)pValue, argDecl, secret);
        } else {
            PreferencesTools.putArgString(preferences, name, pValue, secret);
        }
    }

    public static void putEnumItem(IPreferences preferences, String name, EnumItem item) {
        preferences.put(name, item.getId());
    }

    public static void putLarge(IPreferences preferences, String name, String longValue) {
        try {
            String subKey;
            preferences.remove(name);
            IPreferences childNode = preferences.node(name);
            childNode.clear();
            StringReader reader = new StringReader(longValue);
            char[] buffer = new char[8192];
            int i = 0;
            String subValue = null;
            int length = reader.read(buffer);
            while (length != -1) {
                subKey = "part" + i++;
                subValue = new String(buffer, 0, length);
                childNode.put(subKey, subValue);
                length = reader.read(buffer);
            }
            if (subValue != null && subValue.length() == 8192) {
                subKey = "part" + i++;
                subValue = "";
                childNode.put(subKey, subValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void putSecret(IPreferences preferences, String name, String value) {
        if (CryptoEnvironment.get() == null) {
            Log.log(Level.WARNING, "CryptoEnvironment not available, can't write preference '" + name + "'");
            return;
        }
        try {
            String tempValue = CryptoEnvironment.get().encryptStringEncoded(value);
            preferences.put(name, tempValue);
        }
        catch (IOException e) {
            Log.log(Level.WARNING, "CryptoEnvironment can't encrypt preference '" + name + "'");
        }
    }

    public static Rectangle toRect(String value) {
        if (value == null) {
            return null;
        }
        int[] rectDef = Converter.asIntArray(value);
        if (rectDef == null || rectDef.length < 4) {
            return null;
        }
        return new Rectangle(rectDef[0], rectDef[1], rectDef[2], rectDef[3]);
    }

    public static Rectangle toRect(String value, int[] ranges) {
        if (value == null) {
            return null;
        }
        String[] rectDefs = Converter.asStringArray(value);
        if (rectDefs == null || rectDefs.length != 4) {
            return null;
        }
        int[] rectValues = new int[4];
        int i = 0;
        while (i < rectDefs.length) {
            String rectDef = rectDefs[i];
            if (rectDef.indexOf("%") >= 0) {
                rectDef = rectDef.replaceAll("%", "");
                try {
                    rectValues[i] = (int)((float)Converter.asInteger(rectDef) * (float)ranges[i] / 100.0f);
                }
                catch (ConverterException e) {
                    rectValues[i] = 0;
                }
            } else {
                try {
                    rectValues[i] = Converter.asInteger(rectDef);
                }
                catch (ConverterException e) {
                    rectValues[i] = 0;
                }
            }
            ++i;
        }
        return new Rectangle(rectValues[0], rectValues[1], rectValues[2], rectValues[3]);
    }

    public static String toString(float[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(int[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String toString(List value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = value.iterator();
        while (it.hasNext()) {
            Object element = it.next();
            sb.append(String.valueOf(element));
            if (!it.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Map map) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            sb.append(String.valueOf(entry.getKey()));
            sb.append(KEY_VALUE_SEPARATOR);
            String value = entry.getValue() == null ? "" : String.valueOf(entry.getValue());
            sb.append((Object)value);
            if (!i.hasNext()) continue;
            sb.append(ELEMENT_SEPARATOR);
        }
        return sb.toString();
    }

    public static String toString(Rectangle rect) {
        if (rect == null) {
            return "";
        }
        int[] rectDef = new int[]{rect.x, rect.y, rect.width, rect.height};
        return PreferencesTools.toString(rectDef);
    }

    public static String toString(String[] value) {
        if (value == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < value.length) {
            if (i != 0) {
                sb.append(ELEMENT_SEPARATOR);
            }
            sb.append(value[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String[] toStringArray(String value) {
        if (value == null) {
            return null;
        }
        StringTokenizer tk = new StringTokenizer(value, ELEMENT_SEPARATOR, false);
        String[] result = new String[tk.countTokens()];
        int i = 0;
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            result[i] = token.trim();
            ++i;
        }
        return result;
    }

    private PreferencesTools() {
    }
}

