/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.presentation;

import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PropertyPresentation;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.valueholder.IValueHolder;
import java.text.Format;

public class PropertyPresentationItem
extends PropertyPresentation
implements IValueHolder {
    private static final Object DYNAMIC = new Object();
    private final String name;
    private final Object value;
    private Format format;
    private final IPresentationSupport valuePresentation = new IPresentationSupport(){

        @Override
        public String getDescription() {
            return PropertyPresentationItem.this.getValueDescription();
        }

        @Override
        public String getIconName() {
            return PropertyPresentationItem.this.getValueIconName();
        }

        @Override
        public String getLabel() {
            return PropertyPresentationItem.this.getValueLabel();
        }

        @Override
        public String getTip() {
            return PropertyPresentationItem.this.getValueTip();
        }
    };

    public PropertyPresentationItem(Object object, String name, String label) {
        super(object, label);
        this.name = name;
        this.value = DYNAMIC;
        this.format = null;
    }

    public PropertyPresentationItem(Object object, String name, String label, Format format) {
        super(object, label);
        this.name = name;
        this.value = DYNAMIC;
        this.format = format;
    }

    public PropertyPresentationItem(Object object, String name, String label, Object value, Format format) {
        super(object, label);
        this.name = name;
        this.value = value;
        this.format = format;
    }

    public PropertyPresentationItem(String label, Object value) {
        super(null, label);
        this.name = null;
        this.value = value;
        this.format = null;
    }

    public PropertyPresentationItem(String label, Object value, Format format) {
        super(null, label);
        this.name = null;
        this.value = value;
        this.format = format;
    }

    protected String basicGetValueDescription() {
        return this.getValueTip();
    }

    protected String basicGetValueIconName() {
        return null;
    }

    protected String basicGetValueLabel() {
        return StringTools.safeString(this.get());
    }

    protected String basicGetValueTip() {
        return this.getValueLabel();
    }

    public Object get() {
        if (this.value == DYNAMIC) {
            try {
                return ObjectTools.get(this.getObject(), this.getName());
            }
            catch (FieldException e) {
                return "<not available>";
            }
        }
        return this.value;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public String getValueDescription() {
        Object value = this.get();
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getDescription();
        }
        return this.basicGetValueDescription();
    }

    public String getValueIconName() {
        Object value = this.get();
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getIconName();
        }
        return this.basicGetValueIconName();
    }

    public String getValueLabel() {
        Object value = this.get();
        if (this.getFormat() != null) {
            try {
                return this.getFormat().format(value);
            }
            catch (Exception e) {
                return "<not available>";
            }
        }
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getLabel();
        }
        return this.basicGetValueLabel();
    }

    @Override
    public IPresentationSupport getValuePresentation() {
        return this.valuePresentation;
    }

    public String getValueTip() {
        Object value = this.get();
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getTip();
        }
        return this.basicGetValueTip();
    }

    public Object set(Object newValue) {
        throw new UnsupportedOperationException();
    }

    public void setFormat(Format format) {
        this.format = format;
    }
}

