/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.presentation;

import de.intarsys.tools.presentation.IPresentationHandler;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.IPresentationSupportFactory;
import de.intarsys.tools.reflect.FieldAccessException;
import de.intarsys.tools.reflect.FieldException;
import de.intarsys.tools.reflect.IFieldHandler;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.string.StringTools;
import java.text.Format;

public class PropertyRenderer
implements IPresentationSupport,
IPresentationHandler,
IFieldHandler,
IPresentationSupportFactory {
    private final String name;
    private final String label;
    private Format format;

    public PropertyRenderer(String name, String label) {
        this.name = name;
        this.label = label;
    }

    public PropertyRenderer(String name, String label, Format format) {
        this.name = name;
        this.label = label;
        this.format = format;
    }

    protected String basicGetDescription(Object object) {
        return this.getTip(object);
    }

    protected String basicGetIconName(Object object) {
        return null;
    }

    protected String basicGetLabel(Object value) {
        return StringTools.safeString(value);
    }

    protected String basicGetTip(Object object) {
        return this.getLabel(object);
    }

    @Override
    public IPresentationSupport createPresentationSupport(Object object) {
        return this.getValuePresentation(object);
    }

    @Override
    public String getDescription() {
        return this.getTip();
    }

    @Override
    public String getDescription(Object object) {
        Object value;
        try {
            value = this.getValue(object);
        }
        catch (FieldAccessException e1) {
            value = "<error>";
        }
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getDescription();
        }
        return this.basicGetDescription(value);
    }

    public IPresentationSupport getFieldPresentation() {
        return this;
    }

    public Format getFormat() {
        return this.format;
    }

    @Override
    public String getIconName() {
        return null;
    }

    @Override
    public String getIconName(Object object) {
        Object value;
        try {
            value = this.getValue(object);
        }
        catch (FieldAccessException e1) {
            value = "<error>";
        }
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getIconName();
        }
        return this.basicGetIconName(value);
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getLabel(Object object) {
        Object value;
        try {
            value = this.getValue(object);
        }
        catch (FieldAccessException e1) {
            value = "<error>";
        }
        if (this.getFormat() != null) {
            try {
                return this.getFormat().format(value);
            }
            catch (Exception e) {
                return "<not available>";
            }
        }
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getLabel();
        }
        return this.basicGetLabel(value);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTip() {
        return this.getLabel();
    }

    @Override
    public String getTip(Object object) {
        Object value;
        try {
            value = this.getValue(object);
        }
        catch (FieldAccessException e1) {
            value = "<error>";
        }
        if (value instanceof IPresentationSupport) {
            return ((IPresentationSupport)value).getTip();
        }
        return this.basicGetTip(value);
    }

    @Override
    public Object getValue(Object object) throws FieldAccessException {
        try {
            return ObjectTools.get(object, this.getName());
        }
        catch (FieldException e) {
            return "<not available>";
        }
    }

    public IPresentationSupport getValuePresentation(final Object object) {
        return new IPresentationSupport(){

            @Override
            public String getDescription() {
                return PropertyRenderer.this.getDescription(object);
            }

            @Override
            public String getIconName() {
                return PropertyRenderer.this.getIconName(object);
            }

            @Override
            public String getLabel() {
                return PropertyRenderer.this.getLabel(object);
            }

            @Override
            public String getTip() {
                return PropertyRenderer.this.getTip(object);
            }
        };
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    @Override
    public Object setValue(Object receiver, Object value) throws FieldAccessException {
        return null;
    }
}

