/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.provider;

import de.intarsys.tools.provider.ProviderConfigurationException;
import de.intarsys.tools.stream.StreamTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Providers {
    public static final char COMMENT = '#';
    public static final String SEPARATOR = ";";
    private static final Map<ClassLoader, Providers> providers = new HashMap<ClassLoader, Providers>();
    private static final String PROVIDERLIST = "META-INF/provider/provider.list";
    private ClassLoader loader;
    private List<ProviderEntry> entries = new ArrayList<ProviderEntry>();
    private static final Logger Log = Logger.getLogger("de.intarsys.tools.provider");

    public static Providers get() {
        return Providers.get(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Providers get(ClassLoader classloader) {
        Map<ClassLoader, Providers> map = providers;
        synchronized (map) {
            Providers result = providers.get(classloader);
            if (result == null) {
                try {
                    result = new Providers(classloader);
                }
                catch (IOException e) {
                    throw new ProviderConfigurationException("error creating providers", e);
                }
                providers.put(classloader, result);
            }
            return result;
        }
    }

    protected Providers(ClassLoader cl) throws IOException {
        this.loader = cl;
        this.init();
    }

    protected void addProvider(ProviderEntry entry) {
        for (ProviderEntry temp : this.entries) {
            if (!temp.serviceName.equals(entry.serviceName) || !temp.providerName.equals(entry.providerName)) continue;
            return;
        }
        this.entries.add(entry);
    }

    private void init() throws IOException {
        Enumeration<URL> providerlistUrls = this.loader == null ? ClassLoader.getSystemResources(PROVIDERLIST) : this.loader.getResources(PROVIDERLIST);
        while (providerlistUrls.hasMoreElements()) {
            URL providerlistUrl = providerlistUrls.nextElement();
            InputStream is = null;
            try {
                is = providerlistUrl.openStream();
                this.register(is);
            }
            finally {
                StreamTools.close(is);
            }
        }
    }

    public <S> Iterator<S> lookupProviders(Class<S> service) {
        return new Iterator<S>(service){
            private ProviderEntry current;
            private String serviceName;
            private Iterator<ProviderEntry> it;
            {
                this.serviceName = clazz.getName();
                this.it = Providers.this.entries.iterator();
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (this.current == null) ** GOTO lbl7
                return true;
lbl-1000:
                // 1 sources

                {
                    temp = this.it.next();
                    if (!this.serviceName.equals(temp.serviceName)) continue;
                    this.current = temp;
                    return true;
lbl7:
                    // 2 sources

                    ** while (this.it.hasNext())
                }
lbl8:
                // 1 sources

                return false;
            }

            @Override
            public S next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProviderEntry temp = this.current;
                this.current = null;
                if (temp.provider == null) {
                    try {
                        temp.provider = Class.forName(temp.providerName, true, Providers.this.loader).newInstance();
                    }
                    catch (Throwable e) {
                        Log.log(Level.FINEST, "loading provider failed", e);
                        throw new ProviderConfigurationException("error loading " + temp.providerName, e);
                    }
                }
                return temp.provider;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void register(InputStream is) throws IOException {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(is, "utf-8"));
            while (this.registerLine(r)) {
            }
        }
        catch (Throwable throwable) {
            StreamTools.close(r);
            throw throwable;
        }
        StreamTools.close(r);
    }

    protected boolean registerLine(BufferedReader r) throws IOException {
        String ln = r.readLine();
        if (ln == null) {
            return false;
        }
        int ci = ln.indexOf(35);
        if (ci >= 0) {
            ln = ln.substring(0, ci);
        }
        if ((ln = ln.trim()).length() == 0) {
            return true;
        }
        String[] parts = ln.split(SEPARATOR);
        if (parts.length < 2) {
            return true;
        }
        ProviderEntry entry = new ProviderEntry();
        entry.serviceName = parts[0].trim();
        entry.providerName = parts[1].trim();
        this.addProvider(entry);
        return true;
    }

    static class ProviderEntry {
        public String serviceName;
        public String providerName;
        public Object provider;

        ProviderEntry() {
        }
    }
}

