/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;

public abstract class AbstractRandomAccess
implements IRandomAccess {
    private Stack positionStack = new Stack();

    @Override
    public InputStream asInputStream() {
        return new MyInputStream();
    }

    @Override
    public OutputStream asOutputStream() {
        return new MyOutputStream();
    }

    @Override
    public void mark() throws IOException {
        this.getPositionStack().push(new Long(this.getOffset()));
    }

    @Override
    public void reset() throws IOException {
        if (this.getPositionStack().isEmpty()) {
            this.seek(0L);
        } else {
            this.seek((Long)this.getPositionStack().pop());
        }
    }

    protected Stack getPositionStack() {
        return this.positionStack;
    }

    class MyInputStream
    extends InputStream {
        private long offset = 0L;

        @Override
        public int read() throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read();
            if (i != -1) {
                ++this.offset;
            }
            return i;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read(b, off, len);
            if (i != -1) {
                this.offset += (long)i;
            }
            return i;
        }

        @Override
        public int read(byte[] b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            int i = AbstractRandomAccess.this.read(b);
            if (i != -1) {
                this.offset += (long)i;
            }
            return i;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class MyOutputStream
    extends OutputStream {
        private long offset = 0L;

        @Override
        public void write(int b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b);
            ++this.offset;
        }

        @Override
        public void write(byte[] b) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b);
            this.offset += (long)b.length;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            AbstractRandomAccess.this.seek(this.offset);
            AbstractRandomAccess.this.write(b, off, len);
            this.offset += (long)len;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

