/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.randomaccess;

import de.intarsys.tools.randomaccess.AbstractRandomAccess;
import java.io.IOException;

public class RandomAccessByteArray
extends AbstractRandomAccess {
    private static final int RESIZE_BYTES = 32;
    protected byte[] data;
    private int offset = 0;
    protected int length;

    public RandomAccessByteArray(byte[] buffer) {
        if (buffer == null) {
            this.data = new byte[32];
            this.length = 0;
        } else {
            this.data = buffer;
            this.length = buffer.length;
        }
    }

    public RandomAccessByteArray(byte[] buffer, int length) {
        if (buffer == null) {
            this.data = new byte[32];
            this.length = 0;
        } else {
            this.data = buffer;
            this.length = length;
        }
    }

    protected final void basicSetLengthResize(int newLength) {
        if (newLength > this.data.length) {
            byte[] newData = newLength - this.data.length < 32 ? new byte[this.data.length + 32] : new byte[newLength];
            System.arraycopy(this.data, 0, newData, 0, this.length);
            this.data = newData;
        }
        this.length = newLength;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void flush() throws IOException {
    }

    protected byte[] getData() {
        return this.data;
    }

    @Override
    public long getLength() throws IOException {
        return this.length;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public int read() {
        if (this.offset < this.length) {
            return this.data[this.offset++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int bufferOffset, int numBytes) {
        int remaining = this.length - this.offset;
        if (numBytes > remaining && (numBytes = remaining) == 0) {
            return -1;
        }
        System.arraycopy(this.data, this.offset, buffer, bufferOffset, numBytes);
        this.offset += numBytes;
        return numBytes;
    }

    @Override
    public void seek(long pOffset) throws IOException {
        this.offset = (int)pOffset;
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    @Override
    public void seekBy(long delta) throws IOException {
        this.offset = (int)((long)this.offset + delta);
        if (this.offset < 0) {
            this.offset = 0;
            throw new IOException("offset less than 0");
        }
    }

    @Override
    public void setLength(long newLength) {
        int tempLength = (int)newLength;
        if (tempLength > this.length) {
            this.basicSetLengthResize(tempLength);
        } else {
            if (this.offset > tempLength) {
                this.offset = tempLength;
            }
            this.length = tempLength;
        }
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.length];
        System.arraycopy(this.data, 0, newbuf, 0, this.length);
        return newbuf;
    }

    @Override
    public void write(byte[] buffer) {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int start, int numBytes) {
        int newLength = this.offset + numBytes;
        if (newLength > this.length) {
            this.basicSetLengthResize(newLength);
        }
        System.arraycopy(buffer, start, this.data, this.offset, numBytes);
        this.offset += numBytes;
    }

    @Override
    public void write(int b) {
        int newLength = this.offset + 1;
        if (newLength > this.length) {
            this.basicSetLengthResize(newLength);
        }
        this.data[this.offset++] = (byte)b;
    }
}

